/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsub;

import com.alibaba.fastjson.JSON;
import junit.framework.TestCase;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.pubsub.PubsubTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class PubsubTableProviderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTableTypePubsub() {
        PubsubTableProvider provider = new PubsubTableProvider();
        Assert.assertEquals((Object)"pubsub", (Object)provider.getTableType());
    }

    @Test
    public void testCreatesTable() {
        PubsubTableProvider provider = new PubsubTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").addMapField("attributes", CalciteUtils.VARCHAR, CalciteUtils.VARCHAR).addRowField("payload", Schema.builder().build()).build();
        Table tableDefinition = PubsubTableProviderTest.tableDefinition().schema(messageSchema).build();
        BeamSqlTable pubsubTable = provider.buildBeamSqlTable(tableDefinition);
        TestCase.assertNotNull((Object)pubsubTable);
        Assert.assertEquals((Object)messageSchema, (Object)pubsubTable.getSchema());
    }

    @Test
    public void testThrowsIfTimestampFieldNotProvided() {
        PubsubTableProvider provider = new PubsubTableProvider();
        Schema messageSchema = Schema.builder().addMapField("attributes", CalciteUtils.VARCHAR, CalciteUtils.VARCHAR).addRowField("payload", Schema.builder().build()).build();
        Table tableDefinition = PubsubTableProviderTest.tableDefinition().schema(messageSchema).build();
        this.thrown.expectMessage("Unsupported");
        this.thrown.expectMessage("'event_timestamp'");
        provider.buildBeamSqlTable(tableDefinition);
    }

    @Test
    public void testCreatesTableWithJustTimestamp() {
        PubsubTableProvider provider = new PubsubTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").build();
        Table tableDefinition = PubsubTableProviderTest.tableDefinition().schema(messageSchema).build();
        BeamSqlTable pubsubTable = provider.buildBeamSqlTable(tableDefinition);
        TestCase.assertNotNull((Object)pubsubTable);
        Assert.assertEquals((Object)messageSchema, (Object)pubsubTable.getSchema());
    }

    @Test
    public void testCreatesFlatTable() {
        PubsubTableProvider provider = new PubsubTableProvider();
        Schema messageSchema = Schema.builder().addDateTimeField("event_timestamp").addStringField("someField").build();
        Table tableDefinition = PubsubTableProviderTest.tableDefinition().schema(messageSchema).build();
        BeamSqlTable pubsubTable = provider.buildBeamSqlTable(tableDefinition);
        TestCase.assertNotNull((Object)pubsubTable);
        Assert.assertEquals((Object)messageSchema, (Object)pubsubTable.getSchema());
    }

    private static Table.Builder tableDefinition() {
        return Table.builder().name("FakeTable").comment("fake table").location("projects/project/topics/topic").schema(Schema.builder().build()).type("pubsub").properties(JSON.parseObject((String)"{ \"timestampAttributeKey\" : \"ts_field\" }"));
    }
}

