/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.parquet;

import java.io.File;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.parquet.ParquetTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ParquetTableProviderTest {
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private static final String FIELD_NAMES = "(name VARCHAR, age BIGINT, country VARCHAR)";
    private static final Schema TABLE_SCHEMA = Schema.builder().addStringField("name").addInt64Field("age").addStringField("country").build();
    private static final Schema PROJECTED_SCHEMA = Schema.builder().addInt64Field("age").addStringField("country").build();

    @Test
    public void testWriteAndReadTable() {
        File destinationFile = new File(this.tempFolder.getRoot(), "person-info/");
        BeamSqlEnv env = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new ParquetTableProvider()});
        env.executeDdl(String.format("CREATE EXTERNAL TABLE PersonInfo %s TYPE parquet LOCATION '%s'", FIELD_NAMES, destinationFile.getAbsolutePath()));
        BeamSqlRelUtils.toPCollection((Pipeline)this.writePipeline, (BeamRelNode)env.parseQuery("INSERT INTO PersonInfo VALUES ('Alan', 22, 'England'), ('John', 42, 'USA')"));
        this.writePipeline.run().waitUntilFinish();
        PCollection rows = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)env.parseQuery("SELECT * FROM PersonInfo"));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)TABLE_SCHEMA).addValues(new Object[]{"Alan", 22L, "England"}).build(), Row.withSchema((Schema)TABLE_SCHEMA).addValues(new Object[]{"John", 42L, "USA"}).build()});
        PCollection filtered = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)env.parseQuery("SELECT * FROM PersonInfo WHERE age > 25"));
        PAssert.that((PCollection)filtered).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)TABLE_SCHEMA).addValues(new Object[]{"John", 42L, "USA"}).build()});
        PCollection projected = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)env.parseQuery("SELECT age, country FROM PersonInfo"));
        PAssert.that((PCollection)projected).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)PROJECTED_SCHEMA).addValues(new Object[]{22L, "England"}).build(), Row.withSchema((Schema)PROJECTED_SCHEMA).addValues(new Object[]{42L, "USA"}).build()});
        PCollection filteredAndProjected = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)env.parseQuery("SELECT age, country FROM PersonInfo WHERE age > 25"));
        PAssert.that((PCollection)filteredAndProjected).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)PROJECTED_SCHEMA).addValues(new Object[]{42L, "USA"}).build()});
        PipelineResult.State state = this.readPipeline.run().waitUntilFinish();
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)state);
    }
}

