/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.mongodb;

import java.util.Arrays;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.mongodb.MongoDbTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.bson.Document;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MongoDbTableTest {
    private static final Schema SCHEMA = Schema.builder().addNullableField("long", Schema.FieldType.INT64).addNullableField("int32", Schema.FieldType.INT32).addNullableField("int16", Schema.FieldType.INT16).addNullableField("byte", Schema.FieldType.BYTE).addNullableField("bool", Schema.FieldType.BOOLEAN).addNullableField("double", Schema.FieldType.DOUBLE).addNullableField("float", Schema.FieldType.FLOAT).addNullableField("string", CalciteUtils.CHAR).addRowField("nested", Schema.builder().addNullableField("int32", Schema.FieldType.INT32).build()).addNullableField("arr", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)).build();
    private static final String JSON_ROW = "{ \"long\" : 9223372036854775807, \"int32\" : 2147483647, \"int16\" : 32767, \"byte\" : 127, \"bool\" : true, \"double\" : 1.0, \"float\" : 1.0, \"string\" : \"string\", \"nested\" : {\"int32\" : 2147483645}, \"arr\" : [\"str1\", \"str2\", \"str3\"] }";
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testDocumentToRowConverter() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("Create document from JSON", (PTransform)Create.of((Object)Document.parse((String)JSON_ROW), (Object[])new Document[0]))).apply("Convert document to Row", (PTransform)MongoDbTable.DocumentToRow.withSchema((Schema)SCHEMA));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Row[]{this.row(SCHEMA, Long.MAX_VALUE, Integer.MAX_VALUE, (short)Short.MAX_VALUE, (byte)127, true, 1.0, Float.valueOf(1.0f), "string", this.row(Schema.builder().addNullableField("int32", Schema.FieldType.INT32).build(), 0x7FFFFFFD), Arrays.asList("str1", "str2", "str3"))});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testRowToDocumentConverter() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply("Create a row", (PTransform)Create.of((Object)this.row(SCHEMA, Long.MAX_VALUE, Integer.MAX_VALUE, (short)Short.MAX_VALUE, (byte)127, true, 1.0, Float.valueOf(1.0f), "string", this.row(Schema.builder().addNullableField("int32", Schema.FieldType.INT32).build(), 0x7FFFFFFD), Arrays.asList("str1", "str2", "str3")), (Object[])new Row[0]).withRowSchema(SCHEMA))).apply("Convert row to document", (PTransform)MongoDbTable.RowToDocument.convert());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Document[]{Document.parse((String)JSON_ROW)});
        this.pipeline.run().waitUntilFinish();
    }

    private Row row(Schema schema, Object ... values) {
        return Row.withSchema((Schema)schema).addValues(values).build();
    }
}

