/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.mongodb;

import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.mongodb.MongoDbTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.mongodb.MongoDbTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MongoDbTableProviderTest {
    private MongoDbTableProvider provider = new MongoDbTableProvider();

    @Test
    public void testGetTableType() {
        Assert.assertEquals((Object)"mongodb", (Object)this.provider.getTableType());
    }

    @Test
    public void testBuildBeamSqlTable() {
        Table table = MongoDbTableProviderTest.fakeTable("TEST", "mongodb://localhost:27017/database/collection");
        BeamSqlTable sqlTable = this.provider.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)sqlTable);
        Assert.assertTrue((boolean)(sqlTable instanceof MongoDbTable));
        MongoDbTable mongoTable = (MongoDbTable)sqlTable;
        Assert.assertEquals((Object)"mongodb://localhost:27017", (Object)mongoTable.dbUri);
        Assert.assertEquals((Object)"database", (Object)mongoTable.dbName);
        Assert.assertEquals((Object)"collection", (Object)mongoTable.dbCollection);
    }

    @Test
    public void testBuildBeamSqlTable_withUsernameOnly() {
        Table table = MongoDbTableProviderTest.fakeTable("TEST", "mongodb://username@localhost:27017/database/collection");
        BeamSqlTable sqlTable = this.provider.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)sqlTable);
        Assert.assertTrue((boolean)(sqlTable instanceof MongoDbTable));
        MongoDbTable mongoTable = (MongoDbTable)sqlTable;
        Assert.assertEquals((Object)"mongodb://username@localhost:27017", (Object)mongoTable.dbUri);
        Assert.assertEquals((Object)"database", (Object)mongoTable.dbName);
        Assert.assertEquals((Object)"collection", (Object)mongoTable.dbCollection);
    }

    @Test
    public void testBuildBeamSqlTable_withUsernameAndPassword() {
        Table table = MongoDbTableProviderTest.fakeTable("TEST", "mongodb://username:pasword@localhost:27017/database/collection");
        BeamSqlTable sqlTable = this.provider.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)sqlTable);
        Assert.assertTrue((boolean)(sqlTable instanceof MongoDbTable));
        MongoDbTable mongoTable = (MongoDbTable)sqlTable;
        Assert.assertEquals((Object)"mongodb://username:pasword@localhost:27017", (Object)mongoTable.dbUri);
        Assert.assertEquals((Object)"database", (Object)mongoTable.dbName);
        Assert.assertEquals((Object)"collection", (Object)mongoTable.dbCollection);
    }

    @Test
    public void testBuildBeamSqlTable_withBadLocation_throwsException() {
        ImmutableList badLocations = ImmutableList.of((Object)"mongodb://localhost:27017/database/", (Object)"mongodb://localhost:27017/database", (Object)"localhost:27017/database/collection", (Object)"mongodb://:27017/database/collection", (Object)"mongodb://localhost:27017//collection", (Object)"mongodb://localhost/database/collection", (Object)"mongodb://localhost:/database/collection");
        for (String badLocation : badLocations) {
            Table table = MongoDbTableProviderTest.fakeTable("TEST", badLocation);
            Assert.assertThrows(IllegalArgumentException.class, () -> this.provider.buildBeamSqlTable(table));
        }
    }

    private static Table fakeTable(String name, String location) {
        return Table.builder().name(name).comment(name + " table").location(location).schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type("mongodb").build();
    }
}

