/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.mongodb;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.mongodb.MongoDbTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MongoDbFilterTest {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt16Field("unused2").addBooleanField("b").build();
    private BeamSqlEnv sqlEnv;
    @Parameterized.Parameter
    public String query;
    @Parameterized.Parameter(value=1)
    public boolean isSupported;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"select * from TEST where unused1=100", true}, {"select * from TEST where unused1 in (100, 200)", true}, {"select * from TEST where b", true}, {"select * from TEST where not b", true}, {"select * from TEST where unused1>100 and unused1<=200 and id<>1 and (name='two' or id=2)", true}, {"select * from TEST where name like 'o%e'", false}, {"select * from TEST where unused1+10=110", false}, {"select * from TEST where unused1=unused2 and id=2", false}, {"select * from TEST where unused1+unused2=10", false});
    }

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = MongoDbFilterTest.getTable("TEST", TestTableProvider.PushDownOptions.NONE);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{MongoDbFilterTest.row(BASIC_SCHEMA, 100, 1, "one", (short)100, true), MongoDbFilterTest.row(BASIC_SCHEMA, 200, 2, "two", (short)200, false)});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    @Test
    public void testIsSupported() {
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(this.query);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)Matchers.instanceOf(BeamCalcRel.class));
        MongoDbTable.MongoDbFilter filter = MongoDbTable.MongoDbFilter.create((List)((List)((BeamCalcRel)beamRelNode).getProgram().split().right));
        MatcherAssert.assertThat((String)("Query: '" + this.query + "' is expected to be " + (this.isSupported ? "supported." : "unsupported.")), (filter.getNotSupported().isEmpty() == this.isSupported ? 1 : 0) != 0);
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }
}

