/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.KafkaTestRecord;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.KafkaTestTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class BeamKafkaTableStatisticsTest {
    @Test
    public void testOrderedArrivalSinglePartitionRate() {
        KafkaTestTable table = this.testTable(1);
        for (int i = 0; i < 100; ++i) {
            table.addRecord(this.createKafkaTestRecord("k" + i, i, 500L * (long)i));
        }
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertEquals((double)2.0, (double)stats.getRate(), (double)0.001);
    }

    @Test
    public void testOrderedArrivalMultiplePartitionsRate() {
        KafkaTestTable table = this.testTable(3);
        for (int i = 0; i < 100; ++i) {
            table.addRecord(this.createKafkaTestRecord("k" + i, i, 500L * (long)i));
        }
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertEquals((double)2.0, (double)stats.getRate(), (double)0.001);
    }

    @Test
    public void testOnePartitionAheadRate() {
        KafkaTestTable table = this.testTable(3);
        for (int i = 0; i < 100; ++i) {
            table.addRecord(this.createKafkaTestRecord("1", i, 1000L * (long)i));
            table.addRecord(this.createKafkaTestRecord("2", i, 500L * (long)i));
        }
        table.setNumberOfRecordsForRate(20);
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertEquals((double)1.0, (double)stats.getRate(), (double)0.001);
    }

    @Test
    public void testLateRecords() {
        KafkaTestTable table = this.testTable(3);
        table.addRecord(this.createKafkaTestRecord("1", 132, 1000L));
        for (int i = 0; i < 98; ++i) {
            table.addRecord(this.createKafkaTestRecord("1", i, 500L));
        }
        table.addRecord(this.createKafkaTestRecord("1", 133, 2000L));
        table.setNumberOfRecordsForRate(200);
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertEquals((double)1.0, (double)stats.getRate(), (double)0.001);
    }

    @Test
    public void testAllLate() {
        KafkaTestTable table = this.testTable(3);
        table.addRecord(this.createKafkaTestRecord("1", 132, 1000L));
        for (int i = 0; i < 98; ++i) {
            table.addRecord(this.createKafkaTestRecord("1", i, 500L));
        }
        table.setNumberOfRecordsForRate(200);
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertTrue((boolean)stats.isUnknown());
    }

    @Test
    public void testEmptyPartitionsRate() {
        KafkaTestTable table = this.testTable(3);
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertTrue((boolean)stats.isUnknown());
    }

    @Test
    public void allTheRecordsSameTimeRate() {
        KafkaTestTable table = this.testTable(3);
        for (int i = 0; i < 100; ++i) {
            table.addRecord(this.createKafkaTestRecord("key" + i, i, 1000L));
        }
        BeamTableStatistics stats = table.getTableStatistics(null);
        Assert.assertTrue((boolean)stats.isUnknown());
    }

    private KafkaTestTable testTable(int partitionsPerTopic) {
        ImmutableList topics = ImmutableList.of((Object)"topic1", (Object)"topic2");
        Schema schema = Schema.builder().addInt32Field("f_int").build();
        return new KafkaTestTable(schema, (List<String>)topics, partitionsPerTopic);
    }

    private KafkaTestRecord createKafkaTestRecord(String key, Integer i, long timestamp) {
        return KafkaTestRecord.create(key, i.toString().getBytes(StandardCharsets.UTF_8), "topic1", timestamp);
    }
}

