/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTableTest;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.KafkaTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class BeamKafkaTableJsonTest
extends BeamKafkaTableTest {
    private static final Schema BOOL_SCHEMA = Schema.builder().addBooleanField("nested_bool").build();
    private static final Schema TEST_SCHEMA = Schema.builder().addInt64Field("long").addStringField("string").addBooleanField("bool").addArrayField("array", Schema.FieldType.STRING).addRowField("row", Schema.builder().addBooleanField("nested_bool").build()).build();

    @Override
    protected byte[] generateEncodedPayload(int i) {
        return this.createJson(i).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected Row generateRow(int i) {
        boolean bool = i % 2 == 0;
        ImmutableList values = ImmutableList.of((Object)i, (Object)("json_value" + i), (Object)bool, (Object)ImmutableList.of((Object)("array" + i)), (Object)Row.withSchema((Schema)BOOL_SCHEMA).attachValues(new Object[]{bool}));
        return Row.withSchema((Schema)TEST_SCHEMA).attachValues((List)values);
    }

    @Override
    protected BeamKafkaTable getBeamKafkaTable() {
        return (BeamKafkaTable)new KafkaTableProvider().buildBeamSqlTable(Table.builder().name("kafka").type("kafka").schema(TEST_SCHEMA).location("localhost/mytopic").properties(JSON.parseObject((String)"{ \"format\": \"json\" }")).build());
    }

    private String createJson(int i) {
        boolean bool = i % 2 == 0;
        return String.format("{  \"long\": %s,  \"string\": \"json_value%s\",  \"bool\": %s,  \"array\": [ \"array%s\" ],  \"row\": {     \"nested_bool\": %s  }}", i, i, bool, i, bool);
    }
}

