/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaCSVTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTableTest;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class BeamKafkaTableCSVTest
extends BeamKafkaTableTest {
    private static final Schema TEST_SCHEMA = Schema.builder().addInt64Field("f_long").addInt32Field("f_int").addInt16Field("f_short").addByteField("f_byte").addDoubleField("f_double").addStringField("f_string").build();

    @Override
    protected byte[] generateEncodedPayload(int i) {
        return this.createCsv(i).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected Row generateRow(int i) {
        ImmutableList values = ImmutableList.of((Object)i, (Object)i, (Object)((short)i), (Object)((byte)i), (Object)i, (Object)("csv_value" + i));
        return Row.withSchema((Schema)TEST_SCHEMA).attachValues((List)values);
    }

    @Override
    protected BeamKafkaTable getBeamKafkaTable() {
        return new BeamKafkaCSVTable(TEST_SCHEMA, "", (List)ImmutableList.of((Object)"mytopic"));
    }

    private String createCsv(int i) {
        return String.format("%s,%s,%s,%s,%s,\"%s\"", i, i, i, i, (double)i, "csv_value" + i);
    }
}

