/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTableTest;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.KafkaTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class BeamKafkaTableAvroTest
extends BeamKafkaTableTest {
    private static final org.apache.beam.sdk.schemas.Schema EMPTY_SCHEMA = org.apache.beam.sdk.schemas.Schema.builder().build();
    private static final org.apache.beam.sdk.schemas.Schema TEST_SCHEMA = org.apache.beam.sdk.schemas.Schema.builder().addInt64Field("f_long").addInt32Field("f_int").addDoubleField("f_double").addStringField("f_string").addBooleanField("f_bool").addRowField("f_row", EMPTY_SCHEMA).addArrayField("f_array", Schema.FieldType.row((org.apache.beam.sdk.schemas.Schema)EMPTY_SCHEMA)).build();
    private static final Schema EMPTY_AVRO_SCHEMA = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)EMPTY_SCHEMA);
    private static final Schema AVRO_SCHEMA = AvroUtils.toAvroSchema((org.apache.beam.sdk.schemas.Schema)TEST_SCHEMA);
    private static final AvroCoder<GenericRecord> AVRO_CODER = AvroCoder.of((Schema)AVRO_SCHEMA);

    @Override
    protected Row generateRow(int i) {
        ImmutableList values = ImmutableList.of((Object)i, (Object)i, (Object)i, (Object)("avro_value" + i), (Object)(i % 2 == 0 ? 1 : 0), (Object)Row.withSchema((org.apache.beam.sdk.schemas.Schema)EMPTY_SCHEMA).build(), (Object)ImmutableList.of((Object)Row.withSchema((org.apache.beam.sdk.schemas.Schema)EMPTY_SCHEMA).build()));
        return Row.withSchema((org.apache.beam.sdk.schemas.Schema)TEST_SCHEMA).addValues((List)values).build();
    }

    @Override
    protected byte[] generateEncodedPayload(int i) {
        GenericData.Record record = new GenericRecordBuilder(AVRO_SCHEMA).set("f_long", (Object)i).set("f_int", (Object)i).set("f_double", (Object)i).set("f_string", (Object)("avro_value" + i)).set("f_bool", (Object)(i % 2 == 0 ? 1 : 0)).set("f_row", (Object)new GenericRecordBuilder(EMPTY_AVRO_SCHEMA).build()).set("f_array", (Object)ImmutableList.of((Object)new GenericRecordBuilder(EMPTY_AVRO_SCHEMA).build())).build();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            AVRO_CODER.encode((Object)record, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    @Override
    protected BeamKafkaTable getBeamKafkaTable() {
        return (BeamKafkaTable)new KafkaTableProvider().buildBeamSqlTable(Table.builder().name("kafka").type("kafka").schema(TEST_SCHEMA).location("localhost/mytopic").properties(JSON.parseObject((String)"{ \"format\": \"avro\" }")).build());
    }
}

