/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.google.cloud.bigtable.emulator.v2.BigtableEmulatorRule;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlCli;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableClientWrapper;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableTestUtils;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BigtableTableWithRowsTest {
    @ClassRule
    public static final BigtableEmulatorRule BIGTABLE_EMULATOR = BigtableEmulatorRule.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    private static BigtableClientWrapper emulatorWrapper;
    private static final String PROJECT = "fakeProject";
    private static final String INSTANCE = "fakeInstance";
    private static final String TABLE = "beamTable";

    @BeforeClass
    public static void setUp() throws Exception {
        emulatorWrapper = new BigtableClientWrapper(PROJECT, INSTANCE, BIGTABLE_EMULATOR.getPort(), null);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        emulatorWrapper.closeSession();
    }

    @Test
    public void testCreatesSchemaCorrectly() {
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new BigtableTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute(BigtableTableTestUtils.createFullTableString(TABLE, this.location()));
        Table table = (Table)metaStore.getTables().get(TABLE);
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)BigtableTableTestUtils.TEST_SCHEMA, (Object)table.getSchema());
    }

    @Test
    public void testSimpleSelect() {
        BigtableTableTestUtils.createReadTable(TABLE, emulatorWrapper);
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFullTableString(TABLE, this.location()));
        String query = "SELECT key, \n  bt.familyTest.boolColumn, \n  bt.familyTest.longColumn.val AS longValue, \n  bt.familyTest.longColumn.timestampMicros, \n  bt.familyTest.longColumn.labels, \n  bt.familyTest.stringColumn, \n  bt.familyTest.doubleColumn \nFROM beamTable bt";
        sqlEnv.parseQuery(query);
        PCollection queryOutput = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)sqlEnv.parseQuery(query));
        MatcherAssert.assertThat((Object)queryOutput.getSchema(), (Matcher)Matchers.equalTo((Object)BigtableTableTestUtils.expectedFullSchema()));
        PCollection sorted = ((PCollection)queryOutput.apply((PTransform)MapElements.via((SimpleFunction)new SortByTimestamp()))).setRowSchema(BigtableTableTestUtils.expectedFullSchema());
        PAssert.that((PCollection)sorted).containsInAnyOrder((Object[])new Row[]{BigtableTableTestUtils.expectedFullRow("key1"), BigtableTableTestUtils.expectedFullRow("key2")});
        this.readPipeline.run().waitUntilFinish();
    }

    private String location() {
        return BigtableTableTestUtils.location(PROJECT, INSTANCE, TABLE, BIGTABLE_EMULATOR.getPort());
    }

    private static class SortByTimestamp
    extends SimpleFunction<Row, Row> {
        private SortByTimestamp() {
        }

        public Row apply(Row input) {
            return Row.fromRow((Row)input).withFieldValue("stringColumn", (Object)ImmutableList.copyOf((Collection)input.getArray("stringColumn").stream().sorted().collect(Collectors.toList()))).build();
        }
    }
}

