/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.Row;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableClientWrapper;
import org.apache.beam.sdk.io.gcp.testing.BigtableUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

class BigtableTableTestUtils {
    static final String KEY1 = "key1";
    static final String KEY2 = "key2";
    static final String BOOL_COLUMN = "boolColumn";
    static final String LONG_COLUMN = "longColumn";
    static final String STRING_COLUMN = "stringColumn";
    static final String DOUBLE_COLUMN = "doubleColumn";
    static final String FAMILY_TEST = "familyTest";
    static final Schema LONG_COLUMN_SCHEMA = Schema.builder().addInt64Field("val").addInt64Field("timestampMicros").addArrayField("labels", Schema.FieldType.STRING).build();
    static final Schema TEST_FAMILY_SCHEMA = Schema.builder().addBooleanField("boolColumn").addRowField("longColumn", LONG_COLUMN_SCHEMA).addArrayField("stringColumn", Schema.FieldType.STRING).addDoubleField("doubleColumn").build();
    static final Schema TEST_SCHEMA = Schema.builder().addStringField("key").addRowField("familyTest", TEST_FAMILY_SCHEMA).build();
    static final Schema TEST_FLAT_SCHEMA = Schema.builder().addStringField("key").addBooleanField("boolColumn").addInt64Field("longColumn").addStringField("stringColumn").addDoubleField("doubleColumn").build();
    static final long NOW = 5000000000L;
    static final long LATER = 5000001000L;

    BigtableTableTestUtils() {
    }

    static String createFlatTableString(String table, String location) {
        return String.format("CREATE EXTERNAL TABLE `%s`( \n  key VARCHAR NOT NULL, \n  boolColumn BOOLEAN NOT NULL, \n  longColumn BIGINT NOT NULL, \n  stringColumn VARCHAR NOT NULL, \n  doubleColumn DOUBLE NOT NULL \n) \nTYPE bigtable \nLOCATION '%s' \nTBLPROPERTIES '{ \n  \"columnsMapping\": \"%s\"}'", table, location, BigtableTableTestUtils.columnsMappingString());
    }

    static String createFullTableString(String tableId, String location) {
        return String.format("CREATE EXTERNAL TABLE `%s`( \n  key VARCHAR NOT NULL, \n  familyTest ROW< \n    boolColumn BOOLEAN NOT NULL, \n    longColumn ROW< \n      val BIGINT NOT NULL, \n      timestampMicros BIGINT NOT NULL, \n      labels ARRAY<VARCHAR> NOT NULL \n    > NOT NULL, \n    stringColumn ARRAY<VARCHAR> NOT NULL, \n    doubleColumn DOUBLE NOT NULL \n  > NOT NULL \n) \nTYPE bigtable \nLOCATION '%s'", tableId, location);
    }

    static Schema expectedFullSchema() {
        return Schema.builder().addStringField("key").addBooleanField(BOOL_COLUMN).addInt64Field("longValue").addInt64Field("timestampMicros").addArrayField("labels", Schema.FieldType.STRING).addArrayField(STRING_COLUMN, Schema.FieldType.STRING).addDoubleField(DOUBLE_COLUMN).build();
    }

    static org.apache.beam.sdk.values.Row expectedFullRow(String key) {
        return org.apache.beam.sdk.values.Row.withSchema((Schema)BigtableTableTestUtils.expectedFullSchema()).attachValues(new Object[]{key, false, 2L, 5000001000L, ImmutableList.of(), ImmutableList.of((Object)"string1", (Object)"string2"), 2.2});
    }

    static org.apache.beam.sdk.values.Row flatRow(String key) {
        return org.apache.beam.sdk.values.Row.withSchema((Schema)TEST_FLAT_SCHEMA).attachValues(new Object[]{key, false, 2L, "string2", 2.2});
    }

    static String location(String project, String instanceId, String tableId, @Nullable Integer emulatorPort) {
        String host = emulatorPort == null ? "googleapis.com" : "localhost:" + emulatorPort;
        return String.format("%s/bigtable/projects/%s/instances/%s/tables/%s", host, project, instanceId, tableId);
    }

    static String columnsMappingString() {
        return "familyTest:boolColumn,familyTest:longColumn,familyTest:doubleColumn,familyTest:stringColumn";
    }

    static void createReadTable(String table, BigtableClientWrapper clientWrapper) {
        clientWrapper.createTable(table, FAMILY_TEST);
        BigtableTableTestUtils.writeRow(KEY1, table, clientWrapper);
        BigtableTableTestUtils.writeRow(KEY2, table, clientWrapper);
    }

    static Row bigTableRow() {
        ImmutableList columns = ImmutableList.of((Object)BigtableTableTestUtils.column(BOOL_COLUMN, BigtableUtils.booleanToByteArray((boolean)true)), (Object)BigtableTableTestUtils.column(DOUBLE_COLUMN, BigtableUtils.doubleToByteArray((double)5.5)), (Object)BigtableTableTestUtils.column(LONG_COLUMN, Longs.toByteArray((long)10L)), (Object)BigtableTableTestUtils.column(STRING_COLUMN, "stringValue".getBytes(StandardCharsets.UTF_8)));
        Family family = Family.newBuilder().setName(FAMILY_TEST).addAllColumns((Iterable)columns).build();
        return Row.newBuilder().setKey(BigtableUtils.byteStringUtf8((String)"key")).addFamilies(family).build();
    }

    static Row setFixedTimestamp(Row row) {
        Family family = row.getFamilies(0);
        List columnsReplaced = family.getColumnsList().stream().map(column -> {
            Cell cell = column.getCells(0);
            return BigtableTableTestUtils.column(column.getQualifier().toStringUtf8(), cell.getValue().toByteArray());
        }).collect(Collectors.toList());
        Family familyReplaced = Family.newBuilder().setName(family.getName()).addAllColumns(columnsReplaced).build();
        return Row.newBuilder().setKey(row.getKey()).addFamilies(familyReplaced).build();
    }

    static void checkMessage(@Nullable String message, String substring) {
        if (message != null) {
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)substring));
        } else {
            Assert.fail();
        }
    }

    private static Column column(String qualifier, byte[] value) {
        return Column.newBuilder().setQualifier(BigtableUtils.byteStringUtf8((String)qualifier)).addCells(BigtableTableTestUtils.cell(value)).build();
    }

    private static Cell cell(byte[] value) {
        return Cell.newBuilder().setValue(BigtableUtils.byteString((byte[])value)).setTimestampMicros(5000000000L).build();
    }

    private static void writeRow(String key, String table, BigtableClientWrapper clientWrapper) {
        clientWrapper.writeRow(key, table, FAMILY_TEST, BOOL_COLUMN, BigtableUtils.booleanToByteArray((boolean)true), 5000000000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, BOOL_COLUMN, BigtableUtils.booleanToByteArray((boolean)false), 5000001000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, STRING_COLUMN, "string1".getBytes(StandardCharsets.UTF_8), 5000000000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, STRING_COLUMN, "string2".getBytes(StandardCharsets.UTF_8), 5000001000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, LONG_COLUMN, BigtableUtils.longToByteArray((long)1L), 5000000000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, LONG_COLUMN, BigtableUtils.longToByteArray((long)2L), 5000001000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, DOUBLE_COLUMN, BigtableUtils.doubleToByteArray((double)1.1), 5000000000L);
        clientWrapper.writeRow(key, table, FAMILY_TEST, DOUBLE_COLUMN, BigtableUtils.doubleToByteArray((double)2.2), 5000001000L);
    }
}

