/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.google.auth.Credentials;
import com.google.cloud.bigtable.emulator.v2.Emulator;
import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableClientWrapper;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableTestUtils;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableTableIT {
    private static BigtableTestOptions options;
    private static BigtableClientWrapper clientWrapper;
    private static final String TABLE_ID;
    private static Emulator emulator;

    @BeforeClass
    public static void setup() throws Exception {
        PipelineOptionsFactory.register(BigtableTestOptions.class);
        options = (BigtableTestOptions)TestPipeline.testingPipelineOptions().as(BigtableTestOptions.class);
        if (options.isWithEmulator().booleanValue()) {
            emulator = Emulator.createBundled();
            emulator.start();
        }
        Credentials credentials = options.isWithEmulator() != false ? null : ((GcpOptions)options.as(GcpOptions.class)).getGcpCredential();
        Integer emulatorPort = options.isWithEmulator() != false ? Integer.valueOf(emulator.getPort()) : null;
        clientWrapper = new BigtableClientWrapper(options.getBigtableProject(), options.getInstanceId(), emulatorPort, credentials);
        clientWrapper.createTable(TABLE_ID, "familyTest");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        clientWrapper.deleteTable(TABLE_ID);
        clientWrapper.closeSession();
        if (emulator != null) {
            emulator.stop();
        }
    }

    @Test
    public void testWriteThenRead() {
        this.writeData();
        this.readFlatData();
        this.readData();
    }

    private void writeData() {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFlatTableString(TABLE_ID, this.location()));
        String query = String.format("INSERT INTO `%s`(key, boolColumn, longColumn, stringColumn, doubleColumn) VALUES ('key1', FALSE, CAST(1 as bigint), 'string1', 1.0)", TABLE_ID);
        BeamSqlRelUtils.toPCollection((Pipeline)p, (BeamRelNode)sqlEnv.parseQuery(query));
        p.run().waitUntilFinish();
    }

    private void readFlatData() {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFlatTableString(TABLE_ID, this.location()));
        String query = "SELECT * FROM `" + TABLE_ID + "`";
        PCollection flatRows = BeamSqlRelUtils.toPCollection((Pipeline)p, (BeamRelNode)sqlEnv.parseQuery(query));
        PAssert.that((PCollection)flatRows).containsInAnyOrder((Object[])new Row[]{this.expectedFlatRow(1)});
        p.run().waitUntilFinish();
    }

    private void readData() {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFullTableString(TABLE_ID, this.location()));
        String query = String.format("SELECT key,   t.familyTest.boolColumn,   t.familyTest.longColumn.val AS longValue,   t.familyTest.longColumn.timestampMicros,   t.familyTest.longColumn.labels,   t.familyTest.stringColumn,   t.familyTest.doubleColumn FROM `%s` t", TABLE_ID);
        PCollection rows = ((PCollection)BeamSqlRelUtils.toPCollection((Pipeline)p, (BeamRelNode)sqlEnv.parseQuery(query)).apply((PTransform)MapElements.via((SimpleFunction)new ReplaceTimestamp()))).setRowSchema(BigtableTableTestUtils.expectedFullSchema());
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{this.expectedFullRow(1)});
        p.run().waitUntilFinish();
    }

    private Row expectedFullRow(int i) {
        return Row.withSchema((Schema)BigtableTableTestUtils.expectedFullSchema()).attachValues(new Object[]{"key" + i, i % 2 == 0, (long)i, 5000000000L, ImmutableList.of(), ImmutableList.of((Object)("string" + i)), (double)i});
    }

    private Row expectedFlatRow(int i) {
        return Row.withSchema((Schema)BigtableTableTestUtils.TEST_FLAT_SCHEMA).attachValues(new Object[]{"key" + i, i % 2 == 0, (long)i, "string" + i, (double)i});
    }

    private String location() {
        Integer emulatorPort = options.isWithEmulator() != false ? Integer.valueOf(emulator.getPort()) : null;
        return BigtableTableTestUtils.location(options.getBigtableProject(), options.getInstanceId(), TABLE_ID, emulatorPort);
    }

    static {
        TABLE_ID = "Beam" + UUID.randomUUID();
    }

    public static interface BigtableTestOptions
    extends TestPipelineOptions {
        @Description(value="Instance ID for Bigtable")
        @Default.String(value="fakeInstance")
        public String getInstanceId();

        public void setInstanceId(String var1);

        @Description(value="Project for Bigtable")
        @Default.String(value="fakeProject")
        public String getBigtableProject();

        public void setBigtableProject(String var1);

        @Description(value="Whether to use emulator")
        @Default.Boolean(value=true)
        public Boolean isWithEmulator();

        public void setWithEmulator(Boolean var1);
    }

    private static class ReplaceTimestamp
    extends SimpleFunction<Row, Row> {
        private ReplaceTimestamp() {
        }

        public Row apply(Row input) {
            return Row.fromRow((Row)input).withFieldValue("timestampMicros", (Object)5000000000L).build();
        }
    }
}

