/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.alibaba.fastjson.JSONObject;
import com.google.bigtable.v2.Row;
import com.google.cloud.bigtable.emulator.v2.BigtableEmulatorRule;
import java.io.IOException;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.BeamSqlCli;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableClientWrapper;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableTestUtils;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BigtableTableFlatTest {
    @ClassRule
    public static final BigtableEmulatorRule BIGTABLE_EMULATOR = BigtableEmulatorRule.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    private static BigtableClientWrapper emulatorWrapper;
    private static final String PROJECT = "fakeProject";
    private static final String INSTANCE = "fakeInstance";

    @BeforeClass
    public static void setUp() throws Exception {
        emulatorWrapper = new BigtableClientWrapper(PROJECT, INSTANCE, BIGTABLE_EMULATOR.getPort(), null);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        emulatorWrapper.closeSession();
    }

    @Test
    public void testCreatesFlatSchemaCorrectly() {
        String tableId = "flatTableSchema";
        InMemoryMetaStore metaStore = new InMemoryMetaStore();
        metaStore.registerProvider((TableProvider)new BigtableTableProvider());
        BeamSqlCli cli = new BeamSqlCli().metaStore((MetaStore)metaStore);
        cli.execute(BigtableTableTestUtils.createFlatTableString("flatTableSchema", this.location("flatTableSchema")));
        Table table = (Table)metaStore.getTables().get("flatTableSchema");
        Assert.assertNotNull((Object)table);
        Assert.assertEquals((Object)BigtableTableTestUtils.TEST_FLAT_SCHEMA, (Object)table.getSchema());
        JSONObject properties = table.getProperties();
        Assert.assertTrue((boolean)properties.containsKey((Object)"columnsMapping"));
        Assert.assertEquals((Object)BigtableTableTestUtils.columnsMappingString(), (Object)properties.getString("columnsMapping"));
    }

    @Test
    public void testSimpleSelectFlat() {
        String tableId = "flatTable";
        BigtableTableTestUtils.createReadTable("flatTable", emulatorWrapper);
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFlatTableString("flatTable", this.location("flatTable")));
        String query = "SELECT key, boolColumn, longColumn, stringColumn, doubleColumn FROM flatTable";
        sqlEnv.parseQuery(query);
        PCollection queryOutput = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)sqlEnv.parseQuery(query));
        MatcherAssert.assertThat((Object)queryOutput.getSchema(), (Matcher)Matchers.equalTo((Object)BigtableTableTestUtils.TEST_FLAT_SCHEMA));
        PAssert.that((PCollection)queryOutput).containsInAnyOrder((Object[])new org.apache.beam.sdk.values.Row[]{BigtableTableTestUtils.flatRow("key1"), BigtableTableTestUtils.flatRow("key2")});
        this.readPipeline.run().waitUntilFinish();
    }

    @Test
    public void testSelectFlatKeyRegexQuery() {
        String tableId = "regexTable";
        BigtableTableTestUtils.createReadTable("regexTable", emulatorWrapper);
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFlatTableString("regexTable", this.location("regexTable")));
        String query = "SELECT key FROM regexTable WHERE key LIKE '^key[0134]{1}'";
        sqlEnv.parseQuery(query);
        PCollection queryOutput = BeamSqlRelUtils.toPCollection((Pipeline)this.readPipeline, (BeamRelNode)sqlEnv.parseQuery(query));
        MatcherAssert.assertThat((Object)queryOutput.getSchema(), (Matcher)Matchers.equalTo((Object)this.filterSchema()));
        PAssert.that((PCollection)queryOutput).containsInAnyOrder((Object[])new org.apache.beam.sdk.values.Row[]{this.filterRow("key1")});
        this.readPipeline.run().waitUntilFinish();
    }

    @Test
    public void testSimpleInsert() {
        String tableId = "beamWriteTable";
        emulatorWrapper.createTable("beamWriteTable", "familyTest");
        BeamSqlEnv sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{new BigtableTableProvider()});
        sqlEnv.executeDdl(BigtableTableTestUtils.createFlatTableString("beamWriteTable", this.location("beamWriteTable")));
        String query = "INSERT INTO beamWriteTable(key, boolColumn, longColumn, stringColumn, doubleColumn) VALUES ('key', TRUE, CAST(10 AS bigint), 'stringValue', 5.5)";
        BeamSqlRelUtils.toPCollection((Pipeline)this.writePipeline, (BeamRelNode)sqlEnv.parseQuery(query));
        this.writePipeline.run().waitUntilFinish();
        PCollection bigTableRows = (PCollection)((PCollection)this.readPipeline.apply((PTransform)this.readTransform("beamWriteTable"))).apply((PTransform)MapElements.via((SimpleFunction)new ReplaceCellTimestamp()));
        PAssert.that((PCollection)bigTableRows).containsInAnyOrder((Object[])new Row[]{BigtableTableTestUtils.bigTableRow()});
        this.readPipeline.run().waitUntilFinish();
    }

    private String location(String tableId) {
        return BigtableTableTestUtils.location(PROJECT, INSTANCE, tableId, BIGTABLE_EMULATOR.getPort());
    }

    private Schema filterSchema() {
        return Schema.builder().addStringField("key").build();
    }

    private org.apache.beam.sdk.values.Row filterRow(String key) {
        return org.apache.beam.sdk.values.Row.withSchema((Schema)this.filterSchema()).attachValues(new Object[]{key});
    }

    private BigtableIO.Read readTransform(String table) {
        return BigtableIO.read().withProjectId(PROJECT).withInstanceId(INSTANCE).withTableId(table).withEmulator("localhost:" + BIGTABLE_EMULATOR.getPort());
    }

    private static class ReplaceCellTimestamp
    extends SimpleFunction<Row, Row> {
        private ReplaceCellTimestamp() {
        }

        public Row apply(Row input) {
            return BigtableTableTestUtils.setFixedTimestamp(input);
        }
    }
}

