/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import org.apache.beam.sdk.extensions.sql.BeamSqlCli;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableTableTestUtils;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BigtableTableCreationFailuresTest {
    private final InMemoryMetaStore metaStore = new InMemoryMetaStore();
    private final TableProvider tableProvider = new BigtableTableProvider();
    private BeamSqlCli cli;

    @Before
    public void setUp() {
        this.metaStore.registerProvider(this.tableProvider);
        this.cli = new BeamSqlCli().metaStore((MetaStore)this.metaStore);
    }

    @Test
    public void testCreateWithoutTypeFails() {
        String createTable = "CREATE EXTERNAL TABLE failure(something VARCHAR)";
        ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> this.cli.execute(createTable));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "Unable to parse query");
    }

    @Test
    public void testCreateWithoutLocationFails() {
        String createTable = "CREATE EXTERNAL TABLE fail(key VARCHAR, something VARCHAR) \nTYPE bigtable \n";
        this.cli.execute(createTable);
        Table table = (Table)this.metaStore.getTables().get("fail");
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.tableProvider.buildBeamSqlTable(table));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "LOCATION");
    }

    @Test
    public void testCreateWithoutKeyFails() {
        String createTable = "CREATE EXTERNAL TABLE fail(something VARCHAR) \nTYPE bigtable \nLOCATION '" + BigtableTableCreationFailuresTest.location() + "'";
        this.cli.execute(createTable);
        Table table = (Table)this.metaStore.getTables().get("fail");
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.tableProvider.buildBeamSqlTable(table));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "Schema has to contain 'key' field");
    }

    @Test
    public void testCreateWrongKeyTypeFails() {
        String createTable = "CREATE EXTERNAL TABLE fail(key FLOAT) \nTYPE bigtable \nLOCATION '" + BigtableTableCreationFailuresTest.location() + "'";
        this.cli.execute(createTable);
        Table table = (Table)this.metaStore.getTables().get("fail");
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.tableProvider.buildBeamSqlTable(table));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "key field type should be STRING but was FLOAT");
    }

    @Test
    public void testCreatePropertiesDontMatchSchema() {
        String createTable = "CREATE EXTERNAL TABLE fail(key VARCHAR, q BIGINT, qq BINARY) \nTYPE bigtable \nLOCATION '" + BigtableTableCreationFailuresTest.location() + "' \nTBLPROPERTIES '{\"columnsMapping\": \"f:b,f:c\"}'";
        this.cli.execute(createTable);
        Table table = (Table)this.metaStore.getTables().get("fail");
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.tableProvider.buildBeamSqlTable(table));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "does not fit to schema field names");
    }

    @Test
    public void testCreatePropertiesCountNotEqualSchemaFields() {
        String createTable = "CREATE EXTERNAL TABLE fail(key VARCHAR, q BIGINT, qq BINARY) \nTYPE bigtable \nLOCATION '" + BigtableTableCreationFailuresTest.location() + "' \nTBLPROPERTIES '{\"columnsMapping\": \"f:q\"}'";
        this.cli.execute(createTable);
        Table table = (Table)this.metaStore.getTables().get("fail");
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.tableProvider.buildBeamSqlTable(table));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "Schema fields count: '2' does not fit columnsMapping count: '1'");
    }

    @Test
    public void testShouldFailOnIncorrectLocation() {
        String createTable = "CREATE EXTERNAL TABLE fail(key VARCHAR, q BIGINT) \nTYPE bigtable \nLOCATION 'googleapis.com/incorrect/projects/fakeProject/instances/fakeInstance/tables/beamTable' \nTBLPROPERTIES '{\"columnsMapping\": \"f:q\"}'";
        this.cli.execute(createTable);
        Table table = (Table)this.metaStore.getTables().get("fail");
        InvalidTableException e = (InvalidTableException)Assert.assertThrows(InvalidTableException.class, () -> this.tableProvider.buildBeamSqlTable(table));
        BigtableTableTestUtils.checkMessage(e.getMessage(), "Bigtable location must be in the following format:");
    }

    private static String location() {
        return "googleapis.com/bigtable/projects/fakeProject/instances/fakeInstance/tables/beamTable";
    }
}

