/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableFilter;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BigtableFilterTest {
    private static final Schema BASIC_SCHEMA = Schema.builder().addStringField("key").addStringField("name").build();
    private BeamSqlEnv sqlEnv;
    @Parameterized.Parameter
    public String query;
    @Parameterized.Parameter(value=1)
    public boolean isSupported;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"select * from TEST where key = '100'", false}, {"select * from TEST where key >= 'key2'", false}, {"select * from TEST where key LIKE '^key[123]'", true}, {"select * from TEST where key LIKE '^key[abc]' OR key LIKE '^key[bcd]'", false});
    }

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = BigtableFilterTest.getTable("TEST", TestTableProvider.PushDownOptions.NONE);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{BigtableFilterTest.row("key1", "firstName"), BigtableFilterTest.row("key2", "secondName")});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    @Test
    public void testIsSupported() {
        BeamRelNode beamRelNode = this.sqlEnv.parseQuery(this.query);
        MatcherAssert.assertThat((Object)beamRelNode, (Matcher)Matchers.instanceOf(BeamCalcRel.class));
        BigtableFilter filter = new BigtableFilter((List)((BeamCalcRel)beamRelNode).getProgram().split().right, BASIC_SCHEMA);
        MatcherAssert.assertThat((String)("Query: '" + this.query + "' is expected to be " + (this.isSupported ? "supported." : "unsupported.")), (filter.getNotSupported().isEmpty() == this.isSupported ? 1 : 0) != 0);
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }

    private static Row row(String key, String name) {
        return Row.withSchema((Schema)BASIC_SCHEMA).addValues(new Object[]{key, name}).build();
    }
}

