/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.google.auth.Credentials;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.Mutation;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.bigtable.RowUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

class BigtableClientWrapper
implements Serializable {
    private final BigtableTableAdminClient tableAdminClient;
    private final BigtableDataClient dataClient;
    private final BigtableSession session;
    private final BigtableOptions bigtableOptions;

    BigtableClientWrapper(String project, String instanceId, @Nullable Integer emulatorPort, @Nullable Credentials gcpCredentials) throws IOException {
        BigtableOptions.Builder optionsBuilder = BigtableOptions.builder().setProjectId(project).setInstanceId(instanceId).setUserAgent("apache-beam-test");
        if (emulatorPort != null) {
            optionsBuilder.enableEmulator("localhost", emulatorPort.intValue());
        }
        if (gcpCredentials != null) {
            optionsBuilder.setCredentialOptions(CredentialOptions.credential((Credentials)gcpCredentials));
        }
        this.bigtableOptions = optionsBuilder.build();
        this.session = new BigtableSession(this.bigtableOptions);
        this.tableAdminClient = this.session.getTableAdminClient();
        this.dataClient = this.session.getDataClient();
    }

    void writeRow(String key, String table, String familyColumn, String columnQualifier, byte[] value, long timestampMicros) {
        Mutation.SetCell setCell = Mutation.SetCell.newBuilder().setFamilyName(familyColumn).setColumnQualifier(RowUtils.byteStringUtf8((String)columnQualifier)).setValue(RowUtils.byteString((byte[])value)).setTimestampMicros(timestampMicros).build();
        Mutation mutation = Mutation.newBuilder().setSetCell(setCell).build();
        MutateRowRequest mutateRowRequest = MutateRowRequest.newBuilder().setRowKey(RowUtils.byteStringUtf8((String)key)).setTableName(this.bigtableOptions.getInstanceName().toTableNameStr(table)).addMutations(mutation).build();
        this.dataClient.mutateRow(mutateRowRequest);
    }

    void createTable(String tableName, String familyName) {
        Table.Builder tableBuilder = Table.newBuilder();
        tableBuilder.putColumnFamilies(familyName, ColumnFamily.newBuilder().build());
        String instanceName = this.bigtableOptions.getInstanceName().toString();
        CreateTableRequest.Builder createTableRequestBuilder = CreateTableRequest.newBuilder().setParent(instanceName).setTableId(tableName).setTable(tableBuilder.build());
        this.tableAdminClient.createTable(createTableRequestBuilder.build());
    }

    void deleteTable(String tableId) {
        String tableName = this.bigtableOptions.getInstanceName().toTableNameStr(tableId);
        DeleteTableRequest.Builder deleteTableRequestBuilder = DeleteTableRequest.newBuilder().setName(tableName);
        this.tableAdminClient.deleteTable(deleteTableRequestBuilder.build());
    }

    void closeSession() throws IOException {
        this.session.close();
    }
}

