/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTestTable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BigQueryTestTableProvider
extends BigQueryTableProvider {
    private Map<String, Table> tableSpecMap = new HashMap<String, Table>();
    private Map<String, BeamSqlTable> beamSqlTableMap = new HashMap<String, BeamSqlTable>();

    BigQueryTestTableProvider() {
    }

    void addTable(String name, Table table) {
        this.tableSpecMap.put(name, table);
    }

    public @Nullable Table getTable(String tableName) {
        return this.tableSpecMap.get(tableName);
    }

    public BeamSqlTable buildBeamSqlTable(Table table) {
        Object t = this.beamSqlTableMap.get(table.getLocation());
        if (t != null) {
            return t;
        }
        t = new BigQueryTestTable(table, BigQueryUtils.ConversionOptions.builder().setTruncateTimestamps((Boolean)MoreObjects.firstNonNull((Object)table.getProperties().getBoolean("truncateTimestamps"), (Object)false) != false ? BigQueryUtils.ConversionOptions.TruncateTimestamps.TRUNCATE : BigQueryUtils.ConversionOptions.TruncateTimestamps.REJECT).build());
        this.beamSqlTableMap.put(table.getLocation(), (BeamSqlTable)t);
        return t;
    }
}

