/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.alibaba.fastjson.JSON;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.schemas.Schema;
import org.junit.Assert;
import org.junit.Test;

public class BigQueryTableProviderTest {
    private BigQueryTableProvider provider = new BigQueryTableProvider();

    @Test
    public void testGetTableType() throws Exception {
        Assert.assertEquals((Object)"bigquery", (Object)this.provider.getTableType());
    }

    @Test
    public void testBuildBeamSqlTable() throws Exception {
        Table table = BigQueryTableProviderTest.fakeTable("hello");
        BeamSqlTable sqlTable = this.provider.buildBeamSqlTable(table);
        Assert.assertNotNull((Object)sqlTable);
        Assert.assertTrue((boolean)(sqlTable instanceof BigQueryTable));
        BigQueryTable bqTable = (BigQueryTable)sqlTable;
        Assert.assertEquals((Object)"project:dataset.table", (Object)bqTable.bqLocation);
    }

    @Test
    public void testDefaultMethod_whenPropertiesAreNotSet() {
        Table table = BigQueryTableProviderTest.fakeTable("hello");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ, (Object)sqlTable.method);
    }

    @Test
    public void testSelectDefaultMethodExplicitly() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ method: \"" + BigQueryIO.TypedRead.Method.DEFAULT.toString() + "\" }");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.TypedRead.Method.DEFAULT, (Object)sqlTable.method);
    }

    @Test
    public void testSelectDirectReadMethod() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ method: \"" + BigQueryIO.TypedRead.Method.DIRECT_READ.toString() + "\" }");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.TypedRead.Method.DIRECT_READ, (Object)sqlTable.method);
    }

    @Test
    public void testSelectExportMethod() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ method: \"" + BigQueryIO.TypedRead.Method.EXPORT.toString() + "\" }");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.TypedRead.Method.EXPORT, (Object)sqlTable.method);
    }

    @Test
    public void testSelectWriteDispositionMethodTruncate() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ writeDisposition: \"" + BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.toString() + "\" }");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE, (Object)sqlTable.writeDisposition);
    }

    @Test
    public void testSelectWriteDispositionMethodAppend() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ writeDisposition: \"" + BigQueryIO.Write.WriteDisposition.WRITE_APPEND.toString() + "\" }");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.Write.WriteDisposition.WRITE_APPEND, (Object)sqlTable.writeDisposition);
    }

    @Test
    public void testSelectWriteDispositionMethodEmpty() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ writeDisposition: \"" + BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.toString() + "\" }");
        BigQueryTable sqlTable = (BigQueryTable)this.provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)BigQueryIO.Write.WriteDisposition.WRITE_EMPTY, (Object)sqlTable.writeDisposition);
    }

    @Test
    public void testRuntimeExceptionThrown_whenAnInvalidPropertyIsSpecified() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ method: \"blahblah\" }");
        Assert.assertThrows(RuntimeException.class, () -> this.provider.buildBeamSqlTable(table));
    }

    @Test
    public void testRuntimeExceptionThrown_whenAPropertyOfInvalidTypeIsSpecified() {
        Table table = BigQueryTableProviderTest.fakeTableWithProperties("hello", "{ method: 1337 }");
        Assert.assertThrows(RuntimeException.class, () -> this.provider.buildBeamSqlTable(table));
    }

    private static Table fakeTable(String name) {
        return Table.builder().name(name).comment(name + " table").location("project:dataset.table").schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type("bigquery").build();
    }

    private static Table fakeTableWithProperties(String name, String properties) {
        return Table.builder().name(name).comment(name + " table").location("project:dataset.table").schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type("bigquery").properties(JSON.parseObject((String)properties)).build();
    }
}

