/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.List;
import java.util.stream.Stream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTestTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryTestTableProvider;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TestBigQuery;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryRowCountIT {
    private static final Schema SOURCE_SCHEMA = Schema.builder().addNullableField("id", Schema.FieldType.INT64).addNullableField("name", Schema.FieldType.STRING).build();
    private static final String FAKE_JOB_NAME = "testPipelineOptionInjectionFakeJobName";
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient TestPipeline readingPipeline = TestPipeline.create();
    @Rule
    public transient TestBigQuery bigQuery = TestBigQuery.create((Schema)SOURCE_SCHEMA);

    @Test
    public void testEmptyTable() {
        BigQueryTableProvider provider = new BigQueryTableProvider();
        Table table = BigQueryRowCountIT.getTable("testTable", this.bigQuery.tableSpec());
        BeamSqlTable sqlTable = provider.buildBeamSqlTable(table);
        BeamTableStatistics size = sqlTable.getTableStatistics(TestPipeline.testingPipelineOptions());
        Assert.assertNotNull((Object)size);
        Assert.assertEquals((double)0.0, (double)size.getRowCount(), (double)0.1);
    }

    @Test
    public void testNonEmptyTable() {
        BigQueryTableProvider provider = new BigQueryTableProvider();
        Table table = BigQueryRowCountIT.getTable("testTable", this.bigQuery.tableSpec());
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)new TableRow().set("id", (Object)1).set("name", (Object)"name1"), (Object[])new TableRow[]{new TableRow().set("id", (Object)2).set("name", (Object)"name2"), new TableRow().set("id", (Object)3).set("name", (Object)"name3")}).withCoder((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to(this.bigQuery.tableSpec()).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("id").setType("INTEGER"), (Object)new TableFieldSchema().setName("name").setType("STRING")))).withoutValidation());
        this.pipeline.run().waitUntilFinish();
        BeamSqlTable sqlTable = provider.buildBeamSqlTable(table);
        BeamTableStatistics size1 = sqlTable.getTableStatistics(TestPipeline.testingPipelineOptions());
        Assert.assertNotNull((Object)size1);
        Assert.assertEquals((double)3.0, (double)size1.getRowCount(), (double)0.1);
    }

    @Test
    public void testPipelineOptionInjection() {
        BigQueryTestTableProvider provider = new BigQueryTestTableProvider();
        Table table = BigQueryRowCountIT.getTable("testTable", this.bigQuery.tableSpec());
        provider.addTable("testTable", table);
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)new TableRow().set("id", (Object)1).set("name", (Object)"name1"), (Object[])new TableRow[]{new TableRow().set("id", (Object)2).set("name", (Object)"name2"), new TableRow().set("id", (Object)3).set("name", (Object)"name3")}).withCoder((Coder)TableRowJsonCoder.of()))).apply((PTransform)BigQueryIO.writeTableRows().to(this.bigQuery.tableSpec()).withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("id").setType("INTEGER"), (Object)new TableFieldSchema().setName("name").setType("STRING")))).withoutValidation());
        this.pipeline.run().waitUntilFinish();
        this.readingPipeline.getOptions().setJobName(FAKE_JOB_NAME);
        this.readingPipeline.apply((PTransform)SqlTransform.query((String)" select * from testTable ").withDefaultTableProvider("bigquery", (TableProvider)provider));
        this.readingPipeline.run().waitUntilFinish();
        BigQueryTestTable sqlTable = (BigQueryTestTable)provider.buildBeamSqlTable(table);
        Assert.assertEquals((Object)FAKE_JOB_NAME, (Object)sqlTable.getJobName());
    }

    @Test
    public void testFakeTable() {
        BigQueryTableProvider provider = new BigQueryTableProvider();
        Table table = BigQueryRowCountIT.getTable("fakeTable", "project:dataset.table");
        BeamSqlTable sqlTable = provider.buildBeamSqlTable(table);
        BeamTableStatistics size = sqlTable.getTableStatistics(TestPipeline.testingPipelineOptions());
        Assert.assertTrue((boolean)size.isUnknown());
    }

    private static Table getTable(String name, String location) {
        return Table.builder().name(name).comment(name + " table").location(location).schema((Schema)Stream.of(Schema.Field.nullable((String)"id", (Schema.FieldType)Schema.FieldType.INT64), Schema.Field.nullable((String)"name", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema())).type("bigquery").build();
    }
}

