/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.Pair;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BigQueryFilter;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryFilterTest {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt16Field("unused2").addBooleanField("b").build();
    private BeamSqlEnv sqlEnv;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = BigQueryFilterTest.getTable("TEST", TestTableProvider.PushDownOptions.NONE);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{BigQueryFilterTest.row(BASIC_SCHEMA, 100, 1, "one", (short)100, true), BigQueryFilterTest.row(BASIC_SCHEMA, 200, 2, "two", (short)200, false)});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    @Test
    public void testIsSupported() {
        ImmutableList sqlQueries = ImmutableList.of((Object)Pair.of((Object)"select * from TEST where unused1=100", (Object)true), (Object)Pair.of((Object)"select * from TEST where unused1 in (100, 200)", (Object)true), (Object)Pair.of((Object)"select * from TEST where unused1+10=110", (Object)true), (Object)Pair.of((Object)"select * from TEST where b", (Object)true), (Object)Pair.of((Object)"select * from TEST where unused1>100 and unused1<=200 and id<>1 and (name='two' or id=2)", (Object)true), (Object)Pair.of((Object)"select * from TEST where unused2=200", (Object)true), (Object)Pair.of((Object)"select * from TEST where name like 'o%e'", (Object)true), (Object)Pair.of((Object)"select * from TEST where unused1=unused2 and id=2", (Object)false), (Object)Pair.of((Object)"select * from TEST where unused1+unused2=10", (Object)false));
        for (Pair query : sqlQueries) {
            String sql = (String)query.getLeft();
            Boolean isSupported = (Boolean)query.getRight();
            BeamRelNode beamRelNode = this.sqlEnv.parseQuery(sql);
            MatcherAssert.assertThat((Object)beamRelNode, (Matcher)Matchers.instanceOf(BeamCalcRel.class));
            BigQueryFilter filter = new BigQueryFilter((List)((BeamCalcRel)beamRelNode).getProgram().split().right);
            MatcherAssert.assertThat((String)("Query: '" + sql + "' is expected to be " + (isSupported != false ? "supported." : "unsupported.")), (filter.getNotSupported().isEmpty() == isSupported.booleanValue() ? 1 : 0) != 0);
        }
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }
}

