/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.avro;

import java.io.File;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AvroTableProviderTest {
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private static final String FIELD_NAMES = "(name VARCHAR, age BIGINT, country VARCHAR)";
    private static final Schema OUTPUT_ROW_SCHEMA = Schema.builder().addInt64Field("age").addStringField("country").build();

    @Test
    public void testWriteAndReadTable() {
        File destinationFile = new File(this.tempFolder.getRoot(), "person-info.avro");
        String query = "INSERT INTO PersonInfo VALUES ('Alan', 22, 'England'), ('John', 42, 'USA')";
        String ddl = String.format("CREATE EXTERNAL TABLE PersonInfo %s TYPE avro LOCATION '%s'", FIELD_NAMES, destinationFile.getAbsolutePath());
        this.writePipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        this.writePipeline.run().waitUntilFinish();
        String readQuery = "SELECT age, country FROM PersonInfo WHERE age > 25";
        PCollection rows = (PCollection)this.readPipeline.apply((PTransform)SqlTransform.query((String)readQuery).withDdlString(ddl));
        PAssert.that((PCollection)rows).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)OUTPUT_ROW_SCHEMA).addValues(new Object[]{42L, "USA"}).build()});
        PipelineResult.State state = this.readPipeline.run().waitUntilFinish();
        Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)state);
    }
}

