/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.provider.SchemaIOTableProviderWrapper;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TestSchemaIOTableProviderWrapper
extends SchemaIOTableProviderWrapper {
    private static final List<Row> rows = new ArrayList<Row>();

    public SchemaIOProvider getSchemaIOProvider() {
        return new TestSchemaIOProvider();
    }

    public static void addRows(Row ... newRows) {
        rows.addAll(Arrays.asList(newRows));
    }

    private static class TestProjectionProducer
    extends PTransform<PBegin, PCollection<Row>>
    implements ProjectionProducer<PTransform<PBegin, PCollection<Row>>> {
        private final Schema schema;
        private final FieldAccessDescriptor fieldAccessDescriptor;

        TestProjectionProducer(Schema schema, FieldAccessDescriptor fieldAccessDescriptor) {
            this.schema = schema;
            this.fieldAccessDescriptor = fieldAccessDescriptor;
        }

        public PTransform<PBegin, PCollection<Row>> actuateProjectionPushdown(Map<TupleTag<?>, FieldAccessDescriptor> outputFields) {
            Map.Entry output = (Map.Entry)Iterables.getOnlyElement(outputFields.entrySet());
            if (!((TupleTag)output.getKey()).getId().equals("output")) {
                throw new UnsupportedOperationException("Can only do pushdown on the main output.");
            }
            return new TestProjectionProducer(this.schema, (FieldAccessDescriptor)output.getValue());
        }

        public boolean supportsProjectionPushdown() {
            return true;
        }

        public PCollection<Row> expand(PBegin input) {
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Iterable)rows).withRowSchema(this.schema))).apply((PTransform)Select.fieldAccess((FieldAccessDescriptor)this.fieldAccessDescriptor));
        }
    }

    private static class TestSchemaIO
    implements SchemaIO {
        private final Schema schema;

        TestSchemaIO(Schema schema) {
            this.schema = schema;
        }

        public Schema schema() {
            return this.schema;
        }

        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new TestProjectionProducer(this.schema, FieldAccessDescriptor.withAllFields());
        }

        public PTransform<PCollection<Row>, ? extends POutput> buildWriter() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestSchemaIOProvider
    implements SchemaIOProvider {
        private TestSchemaIOProvider() {
        }

        public String identifier() {
            return "TestSchemaIOProvider";
        }

        public Schema configurationSchema() {
            return Schema.of((Schema.Field[])new Schema.Field[0]);
        }

        public SchemaIO from(String location, Row configuration, @Nullable Schema dataSchema) {
            return new TestSchemaIO(dataSchema);
        }

        public boolean requiresDataSchema() {
            return true;
        }

        public PCollection.IsBounded isBounded() {
            return PCollection.IsBounded.BOUNDED;
        }
    }
}

