/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import com.alibaba.fastjson.JSON;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TestSchemaIOTableProviderWrapper;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SchemaIOTableProviderWrapperTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    private static final Schema inputSchema = Schema.builder().addStringField("f_string").addInt64Field("f_long").addBooleanField("f_bool").build();
    private static final List<Row> rows = ImmutableList.of((Object)Row.withSchema((Schema)inputSchema).addValues(new Object[]{"zero", 0L, false}).build(), (Object)Row.withSchema((Schema)inputSchema).addValues(new Object[]{"one", 1L, true}).build());
    private final Table testTable = Table.builder().name("table").comment("table").schema(inputSchema).properties(JSON.parseObject((String)"{}")).type("test").build();

    @BeforeClass
    public static void setUp() {
        TestSchemaIOTableProviderWrapper.addRows((Row[])rows.stream().toArray(Row[]::new));
    }

    @Test
    public void testBuildIOReader() {
        TestSchemaIOTableProviderWrapper provider = new TestSchemaIOTableProviderWrapper();
        BeamSqlTable beamSqlTable = provider.buildBeamSqlTable(this.testTable);
        PCollection result = beamSqlTable.buildIOReader(this.pipeline.begin());
        PAssert.that((PCollection)result).containsInAnyOrder(rows);
        this.pipeline.run();
    }

    @Test
    public void testBuildIOReader_withProjectionPushdown() {
        TestSchemaIOTableProviderWrapper provider = new TestSchemaIOTableProviderWrapper();
        BeamSqlTable beamSqlTable = provider.buildBeamSqlTable(this.testTable);
        PCollection result = beamSqlTable.buildIOReader(this.pipeline.begin(), (BeamSqlTableFilter)new DefaultTableFilter((List)ImmutableList.of()), (List)ImmutableList.of((Object)"f_long"));
        Schema outputSchema = Schema.builder().addInt64Field("f_long").build();
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)outputSchema).addValues(new Object[]{0L}).build(), Row.withSchema((Schema)outputSchema).addValues(new Object[]{1L}).build()});
        this.pipeline.run();
    }
}

