/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.FullNameTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CustomTableResolverTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("id").addStringField("name").build();

    @Test
    public void testSimpleId() {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable", this.row(1, "one"), this.row(2, "two"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testtable").withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testDefaultBuildIOReader_withEmptyParams_returnsPCollection() {
        TestBoundedTable testTable = TestBoundedTable.of((Schema)BASIC_SCHEMA).addRows(new Object[]{1, "one"});
        Row expected = this.row(1, "one");
        PCollection resultWithEmpty = testTable.buildIOReader(this.pipeline.begin(), testTable.constructFilter((List)ImmutableList.of()), (List)ImmutableList.of());
        PAssert.that((PCollection)resultWithEmpty).containsInAnyOrder((Object[])new Row[]{expected});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testDefaultBuildIOReader_withNonEmptyParams_throwsException() {
        TestBoundedTable testTable = TestBoundedTable.of((Schema)BASIC_SCHEMA).addRows(new Object[]{1, "one"});
        Assert.assertThrows(UnsupportedOperationException.class, () -> testTable.buildIOReader(this.pipeline.begin(), new BeamSqlTableFilter(){

            public List<RexNode> getNotSupported() {
                return null;
            }

            public int numSupported() {
                return 0;
            }
        }, (List)ImmutableList.of()));
        Assert.assertThrows(UnsupportedOperationException.class, () -> testTable.buildIOReader(this.pipeline.begin(), (BeamSqlTableFilter)new DefaultTableFilter((List)ImmutableList.of()), (List)ImmutableList.of((Object)"one")));
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testSimpleIdWithExplicitDefaultSchema() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable", this.row(1, "one"), this.row(2, "two"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider.testtable").withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testSimpleIdWithExplicitDefaultSchemaWithMultipleProviders() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable", this.row(1, "one"), this.row(2, "two"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable2", this.row(3, "three"), this.row(4, "four"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider2.testtable2").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(3, "three"), this.row(4, "four")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testSimpleIdWithExplicitNonDefaultSchema() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable", this.row(1, "one"), this.row(2, "two"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable2", this.row(3, "three"), this.row(4, "four"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider2.testtable2").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(3, "three"), this.row(4, "four")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testCompoundIdInDefaultSchema() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah", this.row(1, "one"), this.row(2, "two"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testtable.blah").withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testCompoundIdInExplicitDefaultSchema() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah", this.row(1, "one"), this.row(2, "two"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider.testtable.blah").withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testLongCompoundIdInDefaultSchema() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(1, "one"), this.row(2, "two"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testtable.blah.foo.bar").withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testLongCompoundIdInDefaultSchemaWithMultipleProviders() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(1, "one"), this.row(2, "two"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable_blah_foo_bar", this.row(3, "three"), this.row(4, "four"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testtable.blah.foo.bar").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testLongCompoundIdInExplicitDefaultSchema() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(1, "one"), this.row(2, "two"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider.testtable.blah.foo.bar").withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(1, "one"), this.row(2, "two")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testLongCompoundIdInNonDefaultSchemaSameTableNames() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(1, "one"), this.row(2, "two"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable_blah_foo_bar", this.row(3, "three"), this.row(4, "four"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider2.testtable.blah.foo.bar").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(3, "three"), this.row(4, "four")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testLongCompoundIdInNonDefaultSchemaDifferentNames() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(1, "one"), this.row(2, "two"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable2_blah2_foo2_bar2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable2_blah2_foo2_bar2", this.row(3, "three"), this.row(4, "four"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name FROM testprovider2.testtable2.blah2.foo2.bar2").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(3, "three"), this.row(4, "four")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testJoinWithLongCompoundIds() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(3, "customer"), this.row(2, "nobody"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable_blah_foo_bar2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable_blah_foo_bar2", this.row(4, "customer"), this.row(1, "nobody"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT testprovider2.testtable.blah.foo.bar2.id, testtable.blah.foo.bar.name \nFROM \n  testprovider2.testtable.blah.foo.bar2 \nJOIN \n  testtable.blah.foo.bar \nUSING(name)").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(4, "customer"), this.row(1, "nobody")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testInnerJoinWithLongCompoundIds() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(3, "customer"), this.row(2, "nobody"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable_blah_foo_bar2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable_blah_foo_bar2", this.row(4, "customer"), this.row(1, "nobody"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT testprovider2.testtable.blah.foo.bar2.id, testtable.blah.foo.bar.name \nFROM \n  testprovider2.testtable.blah.foo.bar2 \nJOIN \n  testtable.blah.foo.bar \nUSING(name)").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(4, "customer"), this.row(1, "nobody")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testJoinWithLongCompoundIdsWithAliases() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(3, "customer"), this.row(2, "nobody"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable_blah_foo_bar2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable_blah_foo_bar2", this.row(4, "customer"), this.row(1, "nobody"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT b.id, a.name \nFROM \n  testprovider2.testtable.blah.foo.bar2 AS b \nJOIN \n  testtable.blah.foo.bar a\nUSING(name)").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(4, "customer"), this.row(1, "nobody")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    @Test
    public void testUnionWithLongCompoundIds() throws Exception {
        CustomResolutionTestTableProvider tableProvider = new CustomResolutionTestTableProvider();
        tableProvider.createTable(Table.builder().name("testtable_blah_foo_bar").schema(BASIC_SCHEMA).type("test").build());
        tableProvider.addRows("testtable_blah_foo_bar", this.row(3, "customer"), this.row(2, "nobody"));
        CustomResolutionTestTableProvider tableProvider2 = new CustomResolutionTestTableProvider();
        tableProvider2.createTable(Table.builder().name("testtable_blah_foo_bar2").schema(BASIC_SCHEMA).type("test").build());
        tableProvider2.addRows("testtable_blah_foo_bar2", this.row(4, "customer"), this.row(1, "nobody"));
        PCollection result = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)"SELECT id, name \nFROM \n  testprovider2.testtable.blah.foo.bar2 \nUNION \n    SELECT id, name \n      FROM \n        testtable.blah.foo.bar \n").withTableProvider("testprovider2", (TableProvider)tableProvider2).withDefaultTableProvider("testprovider", (TableProvider)tableProvider));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Row[]{this.row(4, "customer"), this.row(1, "nobody"), this.row(3, "customer"), this.row(2, "nobody")});
        this.pipeline.run().waitUntilFinish(Duration.standardMinutes((long)2L));
    }

    private Row row(int id, String name) {
        return Row.withSchema((Schema)BASIC_SCHEMA).addValues(new Object[]{id, name}).build();
    }

    public static class CustomResolutionTestTableProvider
    extends FullNameTableProvider {
        TestTableProvider delegateTableProvider = new TestTableProvider();

        public Table getTable(String tableName) {
            return this.delegateTableProvider.getTable(tableName);
        }

        public Table getTableByFullName(TableName fullTableName) {
            String actualTableName = String.join((CharSequence)"_", fullTableName.getPath()) + "_" + fullTableName.getTableName();
            return this.delegateTableProvider.getTable(actualTableName);
        }

        public String getTableType() {
            return this.delegateTableProvider.getTableType();
        }

        public void createTable(Table table) {
            this.delegateTableProvider.createTable(table);
        }

        public void addRows(String tableName, Row ... rows) {
            this.delegateTableProvider.addRows(tableName, rows);
        }

        public void dropTable(String tableName) {
            this.delegateTableProvider.dropTable(tableName);
        }

        public Map<String, Table> getTables() {
            return this.delegateTableProvider.getTables();
        }

        public BeamSqlTable buildBeamSqlTable(Table table) {
            return this.delegateTableProvider.buildBeamSqlTable(table);
        }
    }
}

