/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.utils.BigDecimalConverter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BigDecimalConverterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testReturnsConverterForNumericTypes() {
        for (Schema.TypeName numericType : Schema.TypeName.NUMERIC_TYPES) {
            SerializableFunction converter = BigDecimalConverter.forSqlType((Schema.TypeName)numericType);
            Assert.assertNotNull((Object)converter);
            Assert.assertNotNull((Object)converter.apply((Object)BigDecimal.TEN));
        }
    }

    @Test
    public void testThrowsForUnsupportedTypes() {
        this.thrown.expect(UnsupportedOperationException.class);
        BigDecimalConverter.forSqlType((Schema.TypeName)Schema.TypeName.STRING);
    }
}

