/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VarianceFnTest {
    private static final BigDecimal FIFTEEN = new BigDecimal(15);
    private static final BigDecimal THREE = new BigDecimal(3);
    private static final BigDecimal FOUR = new BigDecimal(4);
    private VarianceFn varianceFn;
    private VarianceAccumulator testAccumulatorInput;
    private int expectedExtractedResult;

    @Parameterized.Parameters(name="varianceFn {index}")
    public static Iterable<Object[]> varianceFns() {
        return Arrays.asList({VarianceFn.newPopulation(BigDecimal::intValue), VarianceAccumulator.newVarianceAccumulator((BigDecimal)FIFTEEN, (BigDecimal)THREE, (BigDecimal)BigDecimal.ZERO), 5}, {VarianceFn.newSample(BigDecimal::intValue), VarianceAccumulator.newVarianceAccumulator((BigDecimal)FIFTEEN, (BigDecimal)FOUR, (BigDecimal)BigDecimal.ZERO), 5});
    }

    public VarianceFnTest(VarianceFn varianceFn, VarianceAccumulator testAccumulatorInput, int expectedExtractedResult) {
        this.varianceFn = varianceFn;
        this.testAccumulatorInput = testAccumulatorInput;
        this.expectedExtractedResult = expectedExtractedResult;
    }

    @Test
    public void testCreatesEmptyAccumulator() {
        Assert.assertEquals((Object)VarianceAccumulator.EMPTY, (Object)this.varianceFn.createAccumulator());
    }

    @Test
    public void testReturnsAccumulatorUnchangedForNullInput() {
        VarianceAccumulator accumulator = VarianceAccumulator.newVarianceAccumulator((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN);
        Assert.assertEquals((Object)accumulator, (Object)this.varianceFn.addInput(accumulator, null));
    }

    @Test
    public void testAddsInputToAccumulator() {
        VarianceAccumulator expectedAccumulator = VarianceAccumulator.newVarianceAccumulator((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE, (BigDecimal)new BigDecimal(2));
        Assert.assertEquals((Object)expectedAccumulator, (Object)this.varianceFn.addInput(this.varianceFn.createAccumulator(), (Number)new BigDecimal(2)));
    }

    @Test
    public void testCreatesAccumulatorCoder() {
        Assert.assertNotNull((Object)this.varianceFn.getAccumulatorCoder(CoderRegistry.createDefault(), (Coder)VarIntCoder.of()));
    }

    @Test
    public void testExtractsOutput() {
        Assert.assertEquals((Object)this.expectedExtractedResult, (Object)this.varianceFn.extractOutput(this.testAccumulatorInput));
    }
}

