/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceAccumulator;
import org.junit.Assert;
import org.junit.Test;

public class VarianceAccumulatorTest {
    private static final double DELTA = 1.0E-7;
    private static final BigDecimal FIFTEEN = new BigDecimal(15);
    private static final BigDecimal SIXTEEN = new BigDecimal(16);
    private static final BigDecimal THREE = new BigDecimal(3);
    private static final BigDecimal FOUR = new BigDecimal(4);
    private static final BigDecimal FIVE = new BigDecimal(5);

    @Test
    public void testInitialized() {
        VarianceAccumulator accumulator = VarianceAccumulator.newVarianceAccumulator((BigDecimal)FIFTEEN, (BigDecimal)THREE, (BigDecimal)FOUR);
        Assert.assertNotEquals((Object)VarianceAccumulator.EMPTY, (Object)accumulator);
        Assert.assertEquals((Object)FIFTEEN, (Object)accumulator.variance());
        Assert.assertEquals((Object)THREE, (Object)accumulator.count());
        Assert.assertEquals((Object)FOUR, (Object)accumulator.sum());
    }

    @Test
    public void testEmpty() {
        VarianceAccumulator zeroAccumulator = VarianceAccumulator.newVarianceAccumulator((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        Assert.assertEquals((Object)zeroAccumulator, (Object)VarianceAccumulator.EMPTY);
        Assert.assertEquals((Object)zeroAccumulator, (Object)VarianceAccumulator.ofZeroElements());
    }

    @Test
    public void testAccumulatorOfSingleElement() {
        VarianceAccumulator accumulatorOfSingleElement = VarianceAccumulator.ofSingleElement((BigDecimal)THREE);
        Assert.assertEquals((Object)VarianceAccumulator.newVarianceAccumulator((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE, (BigDecimal)THREE), (Object)accumulatorOfSingleElement);
    }

    @Test
    public void testCombinesEmptyWithEmpty() {
        VarianceAccumulator result = VarianceAccumulator.EMPTY.combineWith(VarianceAccumulator.EMPTY);
        Assert.assertEquals((Object)VarianceAccumulator.EMPTY, (Object)result);
    }

    @Test
    public void testCombinesEmptyWithNonEmpty() {
        VarianceAccumulator result = VarianceAccumulator.EMPTY.combineWith(VarianceAccumulator.ofSingleElement((BigDecimal)THREE));
        Assert.assertEquals((Object)VarianceAccumulator.newVarianceAccumulator((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE, (BigDecimal)THREE), (Object)result);
    }

    @Test
    public void testCombinesNonEmptyWithEmpty() {
        VarianceAccumulator result = VarianceAccumulator.ofSingleElement((BigDecimal)THREE).combineWith(VarianceAccumulator.EMPTY);
        Assert.assertEquals((Object)VarianceAccumulator.newVarianceAccumulator((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE, (BigDecimal)THREE), (Object)result);
    }

    @Test
    public void testCombinesNonTrivial() {
        VarianceAccumulator accumulator1 = VarianceAccumulator.newVarianceAccumulator((BigDecimal)FIFTEEN, (BigDecimal)THREE, (BigDecimal)FOUR);
        VarianceAccumulator accumulator2 = VarianceAccumulator.newVarianceAccumulator((BigDecimal)SIXTEEN, (BigDecimal)FOUR, (BigDecimal)FIVE);
        VarianceAccumulator expectedCombined = VarianceAccumulator.newVarianceAccumulator((BigDecimal)FIFTEEN.add(SIXTEEN).add(new BigDecimal("0.011904762")), (BigDecimal)THREE.add(FOUR), (BigDecimal)FOUR.add(FIVE));
        VarianceAccumulator combined1 = accumulator1.combineWith(accumulator2);
        VarianceAccumulator combined2 = accumulator2.combineWith(accumulator1);
        Assert.assertEquals((double)expectedCombined.variance().doubleValue(), (double)combined1.variance().doubleValue(), (double)1.0E-7);
        Assert.assertEquals((double)expectedCombined.variance().doubleValue(), (double)combined2.variance().doubleValue(), (double)1.0E-7);
        Assert.assertEquals((Object)expectedCombined.count(), (Object)combined1.count());
        Assert.assertEquals((Object)expectedCombined.sum(), (Object)combined1.sum());
        Assert.assertEquals((Object)expectedCombined.count(), (Object)combined2.count());
        Assert.assertEquals((Object)expectedCombined.sum(), (Object)combined2.sum());
    }
}

