/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CountIf;
import org.apache.beam.sdk.transforms.Combine;
import org.junit.Assert;
import org.junit.Test;

public class CountIfTest {
    @Test
    public void testCreatesEmptyAccumulator() {
        long[] accumulator = (long[])CountIf.combineFn().createAccumulator();
        Assert.assertEquals((long)0L, (long)accumulator[0]);
    }

    @Test
    public void testReturnsAccumulatorUnchangedForNullInput() {
        Combine.CombineFn countIfFn = CountIf.combineFn();
        long[] accumulator = (long[])countIfFn.addInput(countIfFn.createAccumulator(), null);
        Assert.assertEquals((long)0L, (long)accumulator[0]);
    }

    @Test
    public void testAddsInputToAccumulator() {
        Combine.CombineFn countIfFn = CountIf.combineFn();
        long[] accumulator = (long[])countIfFn.addInput(countIfFn.createAccumulator(), (Object)Boolean.TRUE);
        Assert.assertEquals((long)1L, (long)accumulator[0]);
    }

    @Test
    public void testCreatesAccumulatorCoder() throws CannotProvideCoderException {
        Assert.assertNotNull((Object)CountIf.combineFn().getAccumulatorCoder(CoderRegistry.createDefault(), (Coder)BooleanCoder.of()));
    }

    @Test
    public void testMergeAccumulators() {
        Combine.CombineFn countIfFn = CountIf.combineFn();
        List accums = Arrays.asList({2L}, {2L});
        long[] accumulator = (long[])countIfFn.mergeAccumulators(accums);
        Assert.assertEquals((long)4L, (long)accumulator[0]);
    }

    @Test
    public void testExtractsOutput() {
        Combine.CombineFn countIfFn = CountIf.combineFn();
        Assert.assertEquals((Object)0L, (Object)countIfFn.extractOutput(countIfFn.createAccumulator()));
    }
}

