/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.DataContext;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.Enumerable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.Linq4j;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollations;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.ScannableTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Statistic;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Statistics;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.impl.AbstractTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.ImmutableBitSet;

final class ThreeTablesSchema
extends AbstractSchema {
    private final ImmutableMap<String, Table> tables;

    public ThreeTablesSchema() {
        ArrayList<Object[]> mediumData = new ArrayList<Object[]>();
        for (int i = 0; i < 3; ++i) {
            mediumData.add(new Object[]{i, 1, 2});
        }
        ArrayList<Object[]> largeData = new ArrayList<Object[]>();
        for (int i = 0; i < 100; ++i) {
            largeData.add(new Object[]{i, 2});
        }
        this.tables = ImmutableMap.builder().put((Object)"small_table", (Object)new PkClusteredTable(factory -> new RelDataTypeFactory.Builder(factory).add("id", factory.createJavaType(Integer.TYPE)).add("medium_key", factory.createJavaType(Integer.TYPE)).build(), ImmutableBitSet.of((int[])new int[]{0}), Arrays.asList({1, 1}, {2, 1}))).put((Object)"medium_table", (Object)new PkClusteredTable(factory -> new RelDataTypeFactory.Builder(factory).add("id", factory.createJavaType(Integer.TYPE)).add("small_key", factory.createJavaType(Integer.TYPE)).add("large_key", factory.createJavaType(Integer.TYPE)).build(), ImmutableBitSet.of((int[])new int[]{0}), mediumData)).put((Object)"large_table", (Object)new PkClusteredTable(factory -> new RelDataTypeFactory.Builder(factory).add("id", factory.createJavaType(Integer.TYPE)).add("medium_key", factory.createJavaType(Integer.TYPE)).build(), ImmutableBitSet.of((int[])new int[]{0}), largeData)).build();
    }

    protected Map<String, Table> getTableMap() {
        return this.tables;
    }

    private static class PkClusteredTable
    extends AbstractTable
    implements ScannableTable {
        private final ImmutableBitSet pkColumns;
        private final List<Object[]> data;
        private final Function<RelDataTypeFactory, RelDataType> typeBuilder;

        PkClusteredTable(Function<RelDataTypeFactory, RelDataType> dataTypeBuilder, ImmutableBitSet pkColumns, List<Object[]> data) {
            this.data = data;
            this.typeBuilder = dataTypeBuilder;
            this.pkColumns = pkColumns;
        }

        public Statistic getStatistic() {
            ArrayList<RelFieldCollation> collationFields = new ArrayList<RelFieldCollation>();
            for (Integer key : this.pkColumns) {
                collationFields.add(new RelFieldCollation(key.intValue(), RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST));
            }
            return Statistics.of((double)this.data.size(), (List)ImmutableList.of((Object)this.pkColumns), (List)ImmutableList.of((Object)RelCollations.of(collationFields)));
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.typeBuilder.apply(typeFactory);
        }

        public Enumerable<Object[]> scan(DataContext root) {
            return Linq4j.asEnumerable(this.data);
        }
    }
}

