/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamIOPushDownRule;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.CoreRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSets;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Pair;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IOPushDownRuleTest {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt32Field("unused2").build();
    private static final List<RelOptRule> defaultRules = ImmutableList.of((Object)BeamCalcRule.INSTANCE, (Object)CoreRules.FILTER_CALC_MERGE, (Object)CoreRules.PROJECT_CALC_MERGE, (Object)CoreRules.FILTER_TO_CALC, (Object)CoreRules.PROJECT_TO_CALC, (Object)CoreRules.CALC_MERGE);
    private BeamSqlEnv sqlEnv;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table table = IOPushDownRuleTest.getTable("TEST", TestTableProvider.PushDownOptions.PROJECT);
        tableProvider.createTable(table);
        tableProvider.addRows(table.getName(), new Row[]{IOPushDownRuleTest.row(BASIC_SCHEMA, 100, 1, "one", 100), IOPushDownRuleTest.row(BASIC_SCHEMA, 200, 2, "two", 200)});
        this.sqlEnv = BeamSqlEnv.builder((TableProvider)tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).setRuleSets((Collection)ImmutableList.of((Object)RuleSets.ofList(defaultRules))).build();
    }

    @Test
    public void testFindUtilisedInputRefs() {
        String sqlQuery = "select id+10 from TEST where name='one'";
        BeamRelNode basicRel = this.sqlEnv.parseQuery(sqlQuery);
        MatcherAssert.assertThat((Object)basicRel, (Matcher)IsInstanceOf.instanceOf(Calc.class));
        Calc calc = (Calc)basicRel;
        Pair projectFilter = calc.getProgram().split();
        ImmutableList projects = (ImmutableList)projectFilter.left;
        ImmutableList filters = (ImmutableList)projectFilter.right;
        HashSet usedFields = new HashSet();
        BeamIOPushDownRule.INSTANCE.findUtilizedInputRefs(calc.getProgram().getInputRowType(), (RexNode)projects.get(0), usedFields);
        MatcherAssert.assertThat(usedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id"}));
        BeamIOPushDownRule.INSTANCE.findUtilizedInputRefs(calc.getProgram().getInputRowType(), (RexNode)filters.get(0), usedFields);
        MatcherAssert.assertThat(usedFields, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id", "name"}));
    }

    @Test
    public void testReMapRexNodeToNewInputs() {
        String sqlQuery = "select id+10 from TEST where name='one'";
        BeamRelNode basicRel = this.sqlEnv.parseQuery(sqlQuery);
        MatcherAssert.assertThat((Object)basicRel, (Matcher)IsInstanceOf.instanceOf(Calc.class));
        Calc calc = (Calc)basicRel;
        Pair projectFilter = calc.getProgram().split();
        ImmutableList projects = (ImmutableList)projectFilter.left;
        ImmutableList filters = (ImmutableList)projectFilter.right;
        ImmutableList mapping = ImmutableList.of((Object)1, (Object)2);
        RexNode newProject = BeamIOPushDownRule.INSTANCE.reMapRexNodeToNewInputs((RexNode)projects.get(0), (List)mapping);
        MatcherAssert.assertThat((Object)newProject.toString(), (Matcher)IsEqual.equalTo((Object)"+($0, 10)"));
        RexNode newFilter = BeamIOPushDownRule.INSTANCE.reMapRexNodeToNewInputs((RexNode)filters.get(0), (List)mapping);
        MatcherAssert.assertThat((Object)newFilter.toString(), (Matcher)IsEqual.equalTo((Object)"=($1, 'one')"));
    }

    @Test
    public void testIsProjectRenameOnlyProgram() {
        ImmutableList tests = ImmutableList.of((Object)Pair.of((Object)Pair.of((Object)"select unused2, name, id from TEST", (Object)true), (Object)true), (Object)Pair.of((Object)Pair.of((Object)"select unused2, name, id from TEST", (Object)false), (Object)false), (Object)Pair.of((Object)Pair.of((Object)"select id from TEST", (Object)false), (Object)true), (Object)Pair.of((Object)Pair.of((Object)"select * from TEST", (Object)false), (Object)true), (Object)Pair.of((Object)Pair.of((Object)"select id, name from TEST", (Object)false), (Object)true), (Object)Pair.of((Object)Pair.of((Object)"select id+10 from TEST", (Object)false), (Object)false), (Object)Pair.of((Object)Pair.of((Object)"select id from TEST where name='one'", (Object)false), (Object)true));
        for (Pair test : tests) {
            String sqlQuery = (String)((Pair)test.left).left;
            boolean projectPushDownSupported = (Boolean)((Pair)test.left).right;
            boolean expectedAnswer = (Boolean)test.right;
            BeamRelNode basicRel = this.sqlEnv.parseQuery(sqlQuery);
            MatcherAssert.assertThat((Object)basicRel, (Matcher)IsInstanceOf.instanceOf(Calc.class));
            Calc calc = (Calc)basicRel;
            MatcherAssert.assertThat((String)test.toString(), (Object)BeamIOPushDownRule.INSTANCE.isProjectRenameOnlyProgram(calc.getProgram(), projectPushDownSupported), (Matcher)IsEqual.equalTo((Object)expectedAnswer));
        }
    }

    private static Row row(Schema schema, Object ... objects) {
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }
}

