/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import com.alibaba.fastjson.JSON;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamAggregationRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamPushDownIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BeamAggregateProjectMergeRuleTest {
    private static final Schema BASIC_SCHEMA = Schema.builder().addInt32Field("unused1").addInt32Field("id").addStringField("name").addInt32Field("unused2").build();
    private BeamSqlEnv sqlEnv;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void buildUp() {
        TestTableProvider tableProvider = new TestTableProvider();
        Table projectTable = BeamAggregateProjectMergeRuleTest.getTable("TEST_PROJECT", TestTableProvider.PushDownOptions.PROJECT);
        Table filterTable = BeamAggregateProjectMergeRuleTest.getTable("TEST_FILTER", TestTableProvider.PushDownOptions.FILTER);
        Table noneTable = BeamAggregateProjectMergeRuleTest.getTable("TEST_NONE", TestTableProvider.PushDownOptions.NONE);
        tableProvider.createTable(projectTable);
        tableProvider.createTable(filterTable);
        tableProvider.createTable(noneTable);
        tableProvider.addRows("TEST_PROJECT", new Row[]{Row.withSchema((Schema)BASIC_SCHEMA).addValues(new Object[]{1, 2, "3", 4}).build()});
        tableProvider.addRows("TEST_FILTER", new Row[]{Row.withSchema((Schema)BASIC_SCHEMA).addValues(new Object[]{1, 2, "3", 4}).build()});
        tableProvider.addRows("TEST_NONE", new Row[]{Row.withSchema((Schema)BASIC_SCHEMA).addValues(new Object[]{1, 2, "3", 4}).build()});
        this.sqlEnv = BeamSqlEnv.inMemory((TableProvider[])new TableProvider[]{tableProvider});
    }

    @Test
    public void testBeamAggregateProjectMergeRule_withProjectTable() {
        String sqlQuery = "select SUM(id) as id_sum from TEST_PROJECT group by name";
        BeamRelNode beamRel = this.sqlEnv.parseQuery(sqlQuery);
        BeamAggregationRel aggregate = (BeamAggregationRel)beamRel.getInput(0);
        BeamIOSourceRel ioSourceRel = (BeamIOSourceRel)aggregate.getInput();
        MatcherAssert.assertThat((Object)ioSourceRel, (Matcher)IsInstanceOf.instanceOf(BeamPushDownIOSourceRel.class));
        MatcherAssert.assertThat((Object)ioSourceRel.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id"}));
    }

    @Test
    public void testBeamAggregateProjectMergeRule_withProjectTable_withPredicate() {
        String sqlQuery = "select SUM(id) as id_sum from TEST_PROJECT where unused1=1 group by name";
        BeamRelNode beamRel = this.sqlEnv.parseQuery(sqlQuery);
        BeamAggregationRel aggregate = (BeamAggregationRel)beamRel.getInput(0);
        BeamCalcRel calc = (BeamCalcRel)aggregate.getInput();
        BeamIOSourceRel ioSourceRel = (BeamIOSourceRel)calc.getInput();
        MatcherAssert.assertThat((Object)ioSourceRel, (Matcher)IsInstanceOf.instanceOf(BeamPushDownIOSourceRel.class));
        MatcherAssert.assertThat((Object)ioSourceRel.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"name", "id", "unused1"}));
    }

    @Test
    public void testBeamAggregateProjectMergeRule_withFilterTable() {
        String sqlQuery = "select SUM(id) as id_sum from TEST_FILTER group by name";
        BeamRelNode beamRel = this.sqlEnv.parseQuery(sqlQuery);
        BeamAggregationRel aggregate = (BeamAggregationRel)beamRel.getInput(0);
        BeamIOSourceRel ioSourceRel = (BeamIOSourceRel)aggregate.getInput();
        MatcherAssert.assertThat((Object)aggregate.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id_sum", "name"}));
        MatcherAssert.assertThat((Object)ioSourceRel, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)ioSourceRel.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"unused1", "name", "id", "unused2"}));
    }

    @Test
    public void testBeamAggregateProjectMergeRule_withNoneTable() {
        String sqlQuery = "select SUM(id) as id_sum from TEST_NONE group by name";
        BeamRelNode beamRel = this.sqlEnv.parseQuery(sqlQuery);
        BeamAggregationRel aggregate = (BeamAggregationRel)beamRel.getInput(0);
        BeamIOSourceRel ioSourceRel = (BeamIOSourceRel)aggregate.getInput();
        MatcherAssert.assertThat((Object)aggregate.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"id_sum", "name"}));
        MatcherAssert.assertThat((Object)ioSourceRel, (Matcher)IsInstanceOf.instanceOf(BeamIOSourceRel.class));
        MatcherAssert.assertThat((Object)ioSourceRel.getRowType().getFieldNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"unused1", "name", "id", "unused2"}));
    }

    private static Table getTable(String name, TestTableProvider.PushDownOptions options) {
        return Table.builder().name(name).comment(name + " table").schema(BASIC_SCHEMA).properties(JSON.parseObject((String)("{ push_down: \"" + options.toString() + "\" }"))).type("test").build();
    }
}

