/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamValuesRel;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamValuesRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamValuesRelTest.registerTable("string_table", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.STRING, "name", Schema.FieldType.STRING, "description"}));
        BeamValuesRelTest.registerTable("int_table", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "c0", Schema.FieldType.INT32, "c1"}));
    }

    @Test
    public void testValues() throws Exception {
        String sql = "insert into string_table(name, description) values ('hello', 'world'), ('james', 'bond')";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.STRING, "name", Schema.FieldType.STRING, "description").addRows("hello", "world", "james", "bond").getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_castInt() throws Exception {
        String sql = "insert into int_table (c0, c1) values(cast(1 as int), cast(2 as int))";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "c0", Schema.FieldType.INT32, "c1").addRows(1, 2).getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_onlySelect() throws Exception {
        String sql = "select 1, '1'";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "EXPR$0", Schema.FieldType.STRING, "EXPR$1").addRows(1, "1").getRows());
        this.pipeline.run();
    }

    @Test
    public void testValues_selectEmpty() throws Exception {
        String sql = "select 1, '1' FROM string_table WHERE false";
        PCollection<Row> rows = BeamValuesRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "EXPR$0", Schema.FieldType.STRING, "EXPR$1").getRows());
        this.pipeline.run();
    }

    @Test
    public void testNodeStatsEstimation() {
        String sql = "SELECT * FROM (VALUES ('value1'),('value2'),('value3'),('value4'),('value5'), ('value6'),('value7'),('value8'),('value9'))";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamValuesRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimate.isUnknown());
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)9.0, (double)estimate.getRowCount(), (double)0.01);
        Assert.assertEquals((double)9.0, (double)estimate.getWindow(), (double)0.01);
    }
}

