/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamUnnestRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        Schema rowSchema = Schema.builder().addStringField("stringField").addInt32Field("intField").build();
        List<Row> nestedRows = Arrays.asList(Row.withSchema((Schema)rowSchema).addValues(new Object[]{"test1", 1}).build(), Row.withSchema((Schema)rowSchema).addValues(new Object[]{"test2", 2}).build());
        BeamUnnestRelTest.registerTable("NESTED", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.STRING, "user_id", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)rowSchema)), "nested"}).addRows(new Object[]{"1", nestedRows}));
    }

    @Test
    public void testUnnest() {
        String sql = "SELECT user_id, p.intField, p.stringField FROM NESTED as t, unnest(t.nested) as p";
        PCollection<Row> rows = BeamUnnestRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.STRING, "user_id", Schema.FieldType.INT32, "intField", Schema.FieldType.STRING, "stringField").addRows("1", 1, "test1", "1", 2, "test2").getRows());
        this.pipeline.run();
    }
}

