/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamUnionRel;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamUnionRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamUnionRelTest.registerTable("ORDER_DETAILS", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0)}));
    }

    @Test
    public void testUnion() throws Exception {
        String sql = "SELECT  order_id, site_id, price FROM ORDER_DETAILS  UNION SELECT  order_id, site_id, price FROM ORDER_DETAILS ";
        PCollection<Row> rows = BeamUnionRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testUnionAll() throws Exception {
        String sql = "SELECT  order_id, site_id, price FROM ORDER_DETAILS UNION ALL  SELECT order_id, site_id, price FROM ORDER_DETAILS";
        PCollection<Row> rows = BeamUnionRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(1L, 1, new BigDecimal(1.0), 1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 2L, 2, new BigDecimal(2.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testNodeStatsEstimation() {
        String sql = "SELECT  order_id, site_id, price FROM ORDER_DETAILS  UNION SELECT  order_id, site_id, price FROM ORDER_DETAILS ";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamUnionRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimate.isUnknown());
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)estimate.getRowCount(), (double)0.01);
        Assert.assertEquals((double)2.0, (double)estimate.getWindow(), (double)0.01);
    }

    @Test
    public void testNodeStatsEstimationUnionAll() {
        String sql = "SELECT  order_id, site_id, price FROM ORDER_DETAILS  UNION ALL SELECT  order_id, site_id, price FROM ORDER_DETAILS ";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamUnionRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimate.isUnknown());
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)4.0, (double)estimate.getRowCount(), (double)0.01);
        Assert.assertEquals((double)4.0, (double)estimate.getWindow(), (double)0.01);
    }
}

