/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamUncollectRel;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class BeamUncollectRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    private NodeStats getEstimateOf(String sql) {
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamUncollectRel)) {
            root = root.getInput(0);
        }
        return BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
    }

    @Test
    public void testNodeStats() {
        NodeStats estimate = this.getEstimateOf("SELECT * FROM UNNEST (SELECT * FROM (VALUES (ARRAY ['a', 'b', 'c']),(ARRAY ['a', 'b', 'c']))) t1");
        Assert.assertEquals((double)4.0, (double)estimate.getRowCount(), (double)0.001);
        Assert.assertEquals((double)4.0, (double)estimate.getWindow(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.001);
    }

    @Test
    public void testUncollectPrimitive() {
        String sql = "SELECT * FROM unnest(ARRAY [1, 2, 3])";
        PCollection<Row> rows = BeamUncollectRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "intField").addRows(1, 2, 3).getRows());
        this.pipeline.run();
    }

    @Test
    public void testUncollectNested() {
        Schema rowSchema = Schema.builder().addStringField("stringField").addInt32Field("intField").build();
        List<Row> nestedRows = Arrays.asList(Row.withSchema((Schema)rowSchema).addValues(new Object[]{"test1", 1}).build(), Row.withSchema((Schema)rowSchema).addValues(new Object[]{"test2", 2}).build());
        BeamUncollectRelTest.registerTable("NESTED", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.STRING, "user_id", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)rowSchema)), "nested"}).addRows(new Object[]{"1", nestedRows}));
        String sql = "SELECT intField, stringField FROM unnest(SELECT nested from NESTED)";
        PCollection<Row> rows = BeamUncollectRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "intField", Schema.FieldType.STRING, "stringField").addRows(1, "test1", 2, "test2").getRows());
        this.pipeline.run();
    }
}

