/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BeamSortRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Before
    public void prepare() {
        BeamSortRelTest.registerTable("ORDER_DETAILS", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price", Schema.FieldType.DATETIME, "order_time"}).addRows(new Object[]{1L, 2, 1.0, new DateTime(0L), 1L, 1, 2.0, new DateTime(1L), 2L, 4, 3.0, new DateTime(2L), 2L, 1, 4.0, new DateTime(3L), 5L, 5, 5.0, new DateTime(4L), 6L, 6, 6.0, new DateTime(5L), 7L, 7, 7.0, new DateTime(6L), 8L, 8888, 8.0, new DateTime(7L), 8L, 999, 9.0, new DateTime(8L), 10L, 100, 10.0, new DateTime(9L)}));
        BeamSortRelTest.registerTable("SUB_ORDER_RAM", (BeamSqlTable)TestBoundedTable.of((Schema)Schema.builder().addField("order_id", Schema.FieldType.INT64).addField("site_id", Schema.FieldType.INT32).addNullableField("price", Schema.FieldType.DOUBLE).build()));
        BeamSortRelTest.registerTable("COUNT_TABLE", (BeamSqlTable)TestBoundedTable.of((Schema)Schema.builder().addField("count_star", Schema.FieldType.INT64).build()));
    }

    @Test
    public void testOrderBy_basic() {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc limit 4";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 2, 1.0, 1L, 1, 2.0, 2L, 4, 3.0, 2L, 1, 4.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_timestamp() {
        String sql = "SELECT order_id, site_id, price, order_time FROM ORDER_DETAILS ORDER BY order_time desc limit 4";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price", Schema.FieldType.DATETIME, "order_time").addRows(7L, 7, 7.0, new DateTime(6L), 8L, 8888, 8.0, new DateTime(7L), 8L, 999, 9.0, new DateTime(8L), 10L, 100, 10.0, new DateTime(9L)).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_nullsFirst() {
        Schema schema = Schema.builder().addField("order_id", Schema.FieldType.INT64).addNullableField("site_id", Schema.FieldType.INT32).addField("price", Schema.FieldType.DOUBLE).build();
        BeamSortRelTest.registerTable("ORDER_DETAILS", (BeamSqlTable)TestBoundedTable.of((Schema)schema).addRows(new Object[]{1L, 2, 1.0, 1L, null, 2.0, 2L, 1, 3.0, 2L, null, 4.0, 5L, 5, 5.0}));
        BeamSortRelTest.registerTable("SUB_ORDER_RAM", (BeamSqlTable)TestBoundedTable.of((Schema)schema));
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc NULLS FIRST limit 4";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(schema).addRows(1L, null, 2.0, 1L, 2, 1.0, 2L, null, 4.0, 2L, 1, 3.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_nullsLast() {
        Schema schema = Schema.builder().addField("order_id", Schema.FieldType.INT64).addNullableField("site_id", Schema.FieldType.INT32).addField("price", Schema.FieldType.DOUBLE).build();
        BeamSortRelTest.registerTable("ORDER_DETAILS", (BeamSqlTable)TestBoundedTable.of((Schema)schema).addRows(new Object[]{1L, 2, 1.0, 1L, null, 2.0, 2L, 1, 3.0, 2L, null, 4.0, 5L, 5, 5.0}));
        BeamSortRelTest.registerTable("SUB_ORDER_RAM", (BeamSqlTable)TestBoundedTable.of((Schema)schema));
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc NULLS LAST limit 4";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(schema).addRows(1L, 2, 1.0, 1L, null, 2.0, 2L, 1, 3.0, 2L, null, 4.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_with_offset2() {
        Schema schema = Schema.builder().addField("count_star", Schema.FieldType.INT64).build();
        String sql = "INSERT INTO COUNT_TABLE(count_star) SELECT COUNT(*) FROM (SELECT * FROM (SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 3) LIMIT 3 OFFSET 1)";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(schema).addRows(2L).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_with_offset() {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc limit 4 offset 4";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(5L, 5, 5.0, 6L, 6, 6.0, 7L, 7, 7.0, 8L, 8888, 8.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_bigFetch() {
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id, price)  SELECT  order_id, site_id, price FROM ORDER_DETAILS ORDER BY order_id asc, site_id desc limit 11";
        PCollection<Row> rows = BeamSortRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DOUBLE, "price").addRows(1L, 2, 1.0, 1L, 1, 2.0, 2L, 4, 3.0, 2L, 1, 4.0, 5L, 5, 5.0, 6L, 6, 6.0, 7L, 7, 7.0, 8L, 8888, 8.0, 8L, 999, 9.0, 10L, 100, 10.0).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testOrderBy_exception() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("`ORDER BY` is only supported for GlobalWindows");
        String sql = "INSERT INTO SUB_ORDER_RAM(order_id, site_id)  SELECT  order_id, COUNT(*) FROM ORDER_DETAILS GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)ORDER BY order_id asc limit 11";
        TestPipeline pipeline = TestPipeline.create();
        BeamSortRelTest.compilePipeline(sql, (Pipeline)pipeline);
    }

    @Test
    public void testNodeStatsEstimation() {
        String sql = "SELECT order_id, site_id, price, order_time FROM ORDER_DETAILS ORDER BY order_time asc limit 11";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamSortRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimate.isUnknown());
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)10.0, (double)estimate.getRowCount(), (double)0.01);
        Assert.assertEquals((double)10.0, (double)estimate.getWindow(), (double)0.01);
    }
}

