/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamMinusRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.CheckSize;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestUnboundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamMinusRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    private static final DateTime FIRST_DATE = new DateTime(1L);
    private static final DateTime SECOND_DATE = new DateTime(3600001L);
    private static final Duration WINDOW_SIZE = Duration.standardHours((long)1L);

    @BeforeClass
    public static void prepare() {
        BeamMinusRelTest.registerTable("ORDER_DETAILS1", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 4L, 4, new BigDecimal(4.0), 4L, 4, new BigDecimal(4.0)}));
        BeamMinusRelTest.registerTable("ORDER_DETAILS2", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 3L, 3, new BigDecimal(3.0)}));
        BeamMinusRelTest.registerTable("ORDER_DETAILS_UNBOUNDED", (BeamSqlTable)TestUnboundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price", Schema.FieldType.DATETIME, "order_time"}).timestampColumnIndex(3).addRows(Duration.ZERO, new Object[]{1, 1, 1, FIRST_DATE, 1, 2, 6, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 2, 7, SECOND_DATE, 2, 3, 8, SECOND_DATE, 1, 3, 3, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)WINDOW_SIZE).plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 3, 3, SECOND_DATE}).setStatistics(BeamTableStatistics.createUnboundedTableStatistics((Double)4.0)));
    }

    @Test
    public void testExcept() {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamMinusRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(4L, 4, new BigDecimal(4.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testExceptAll() {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT ALL SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamMinusRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(3));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(1L, 1, new BigDecimal(1.0), 4L, 4, new BigDecimal(4.0), 4L, 4, new BigDecimal(4.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testExceptRemovesDuplicates() {
        String sql = "(SELECT 1 UNION ALL SELECT 2 UNION ALL SELECT 1) EXCEPT SELECT 1";
        PCollection<Row> rows = BeamMinusRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(1));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT32, "i").addRows(2).getRows());
        this.pipeline.run();
    }

    @Test
    public void testNodeStatsEstimation() {
        String sql = "SELECT order_id, site_id, price FROM ORDER_DETAILS1  EXCEPT ALL SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamMinusRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimate.isUnknown());
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)3.5, (double)estimate.getRowCount(), (double)0.01);
        Assert.assertEquals((double)3.5, (double)estimate.getWindow(), (double)0.01);
    }

    @Test
    public void testNodeStatsEstimationUnbounded() {
        String sql = "SELECT * FROM (select order_id FROM ORDER_DETAILS_UNBOUNDED           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)) o1  EXCEPT ALL  select order_id FROM ORDER_DETAILS_UNBOUNDED           GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR) ";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamMinusRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertEquals((double)1.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)0.0, (double)estimate.getRowCount(), (double)0.01);
    }
}

