/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.TestUtils;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIntersectRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.rel.CheckSize;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamIntersectRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();

    @BeforeClass
    public static void prepare() {
        BeamIntersectRelTest.registerTable("ORDER_DETAILS1", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 4L, 4, new BigDecimal(4.0)}));
        BeamIntersectRelTest.registerTable("ORDER_DETAILS2", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 3L, 3, new BigDecimal(3.0)}));
    }

    @Test
    public void testIntersect() {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  INTERSECT SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamIntersectRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0)).getRows());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testIntersectAll() {
        String sql = "";
        sql = sql + "SELECT order_id, site_id, price FROM ORDER_DETAILS1  INTERSECT ALL SELECT order_id, site_id, price FROM ORDER_DETAILS2 ";
        PCollection<Row> rows = BeamIntersectRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        PAssert.that(rows).satisfies((SerializableFunction)new CheckSize(2));
        PAssert.that(rows).containsInAnyOrder(TestUtils.RowsBuilder.of(Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price").addRows(1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0)).getRows());
        this.pipeline.run();
    }

    @Test
    public void testNodeStatsEstimation() {
        String sql = "SELECT order_id, site_id, price  FROM ORDER_DETAILS1  INTERSECT  SELECT order_id, site_id, price  FROM ORDER_DETAILS2 ";
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamIntersectRel)) {
            root = root.getInput(0);
        }
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimate.isUnknown());
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.01);
        Assert.assertEquals((double)1.5, (double)estimate.getRowCount(), (double)0.01);
        Assert.assertEquals((double)1.5, (double)estimate.getWindow(), (double)0.01);
    }
}

