/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestUnboundedTable;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BeamCalcRelTest
extends BaseRelTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    private static final DateTime FIRST_DATE = new DateTime(1L);
    private static final DateTime SECOND_DATE = new DateTime(3600001L);
    private static final Duration WINDOW_SIZE = Duration.standardHours((long)1L);

    @BeforeClass
    public static void prepare() {
        BeamCalcRelTest.registerTable("ORDER_DETAILS_BOUNDED", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 4L, 4, new BigDecimal(4.0), 4L, 4, new BigDecimal(4.0)}));
        BeamCalcRelTest.registerTable("ORDER_DETAILS_UNBOUNDED", (BeamSqlTable)TestUnboundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price", Schema.FieldType.DATETIME, "order_time"}).timestampColumnIndex(3).addRows(Duration.ZERO, new Object[]{1, 1, 1, FIRST_DATE, 1, 2, 6, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 2, 7, SECOND_DATE, 2, 3, 8, SECOND_DATE, 1, 3, 3, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)WINDOW_SIZE).plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 3, 3, SECOND_DATE}).setStatistics(BeamTableStatistics.createUnboundedTableStatistics((Double)2.0)));
    }

    @Test
    public void testProjectionNodeStats() {
        String sql = "SELECT order_id FROM ORDER_DETAILS_BOUNDED";
        BeamRelNode root = env.parseQuery(sql);
        Assert.assertTrue((boolean)(root instanceof BeamCalcRel));
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertEquals((double)5.0, (double)estimate.getRowCount(), (double)0.001);
        Assert.assertEquals((double)5.0, (double)estimate.getWindow(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.001);
    }

    @Test
    public void testFilterNodeStats() {
        String sql = "SELECT * FROM ORDER_DETAILS_BOUNDED where order_id=1";
        BeamRelNode root = env.parseQuery(sql);
        Assert.assertTrue((boolean)(root instanceof BeamCalcRel));
        NodeStats estimate = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertTrue((5.0 > estimate.getRowCount() ? 1 : 0) != 0);
        Assert.assertTrue((5.0 > estimate.getWindow() ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.001);
    }

    @Test
    public void testNodeStatsConditionType() {
        String equalSql = "SELECT * FROM ORDER_DETAILS_BOUNDED where order_id=1";
        String geqSql = "SELECT * FROM ORDER_DETAILS_BOUNDED where order_id>=1";
        BeamRelNode equalRoot = env.parseQuery(equalSql);
        BeamRelNode geqRoot = env.parseQuery(geqSql);
        NodeStats equalEstimate = BeamSqlRelUtils.getNodeStats((RelNode)equalRoot, (BeamRelMetadataQuery)((BeamRelMetadataQuery)equalRoot.getCluster().getMetadataQuery()));
        NodeStats geqEstimate = BeamSqlRelUtils.getNodeStats((RelNode)geqRoot, (BeamRelMetadataQuery)((BeamRelMetadataQuery)geqRoot.getCluster().getMetadataQuery()));
        Assert.assertTrue((geqEstimate.getRowCount() > equalEstimate.getRowCount() ? 1 : 0) != 0);
        Assert.assertTrue((geqEstimate.getWindow() > equalEstimate.getWindow() ? 1 : 0) != 0);
    }

    @Test
    public void testNodeStatsNumberOfConditions() {
        String equalSql = "SELECT * FROM ORDER_DETAILS_BOUNDED where order_id=1";
        String doubleEqualSql = "SELECT * FROM ORDER_DETAILS_BOUNDED WHERE order_id=1 AND site_id=2 ";
        BeamRelNode equalRoot = env.parseQuery(equalSql);
        BeamRelNode doubleEqualRoot = env.parseQuery(doubleEqualSql);
        NodeStats equalEstimate = BeamSqlRelUtils.getNodeStats((RelNode)equalRoot, (BeamRelMetadataQuery)((BeamRelMetadataQuery)equalRoot.getCluster().getMetadataQuery()));
        NodeStats doubleEqualEstimate = BeamSqlRelUtils.getNodeStats((RelNode)doubleEqualRoot, (BeamRelMetadataQuery)((BeamRelMetadataQuery)doubleEqualRoot.getCluster().getMetadataQuery()));
        Assert.assertTrue((doubleEqualEstimate.getRowCount() < equalEstimate.getRowCount() ? 1 : 0) != 0);
        Assert.assertTrue((doubleEqualEstimate.getWindow() < equalEstimate.getWindow() ? 1 : 0) != 0);
    }

    @Test
    public void testSingleFieldAccess() throws IllegalAccessException {
        String sql = "SELECT order_id FROM ORDER_DETAILS_BOUNDED";
        PCollection<Row> rows = BeamCalcRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        NodeGetter nodeGetter = new NodeGetter((PValue)rows);
        this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)nodeGetter);
        ParDo.MultiOutput pardo = (ParDo.MultiOutput)nodeGetter.producer.getTransform();
        PCollection input = (PCollection)Iterables.getOnlyElement(nodeGetter.producer.getInputs().values());
        DoFnSchemaInformation info = ParDo.getDoFnSchemaInformation((DoFn)pardo.getFn(), (PCollection)input);
        FieldAccessDescriptor fieldAccess = info.getFieldAccessDescriptor();
        Assert.assertTrue((boolean)fieldAccess.referencesSingleField());
        Assert.assertEquals((Object)"order_id", (Object)Iterables.getOnlyElement((Iterable)fieldAccess.fieldNamesAccessed()));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testNoFieldAccess() throws IllegalAccessException {
        String sql = "SELECT 1 FROM ORDER_DETAILS_BOUNDED";
        PCollection<Row> rows = BeamCalcRelTest.compilePipeline(sql, (Pipeline)this.pipeline);
        NodeGetter nodeGetter = new NodeGetter((PValue)rows);
        this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)nodeGetter);
        ParDo.MultiOutput pardo = (ParDo.MultiOutput)nodeGetter.producer.getTransform();
        PCollection input = (PCollection)Iterables.getOnlyElement(nodeGetter.producer.getInputs().values());
        DoFnSchemaInformation info = ParDo.getDoFnSchemaInformation((DoFn)pardo.getFn(), (PCollection)input);
        FieldAccessDescriptor fieldAccess = info.getFieldAccessDescriptor();
        Assert.assertFalse((boolean)fieldAccess.getAllFields());
        Assert.assertTrue((boolean)fieldAccess.getFieldsAccessed().isEmpty());
        Assert.assertTrue((boolean)fieldAccess.getNestedFieldsAccessed().isEmpty());
        this.pipeline.run().waitUntilFinish();
    }

    private static class NodeGetter
    extends Pipeline.PipelineVisitor.Defaults {
        private final PValue target;
        private TransformHierarchy.Node producer;

        private NodeGetter(PValue target) {
            this.target = target;
        }

        public void visitValue(PValue value, TransformHierarchy.Node producer) {
            if (value == this.target) {
                assert (this.producer == null);
                this.producer = producer;
            }
        }
    }
}

