/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamAggregationRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestUnboundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BeamAggregationRelTest
extends BaseRelTest {
    private static final DateTime FIRST_DATE = new DateTime(1L);
    private static final DateTime SECOND_DATE = new DateTime(3600001L);
    private static final Duration WINDOW_SIZE = Duration.standardHours((long)1L);

    @BeforeClass
    public static void prepare() {
        BeamAggregationRelTest.registerTable("ORDER_DETAILS_BOUNDED", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT64, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.DECIMAL, "price"}).addRows(new Object[]{1L, 1, new BigDecimal(1.0), 1L, 1, new BigDecimal(1.0), 2L, 2, new BigDecimal(2.0), 4L, 4, new BigDecimal(4.0), 4L, 4, new BigDecimal(4.0)}));
        BeamAggregationRelTest.registerTable("ORDER_DETAILS_UNBOUNDED", (BeamSqlTable)TestUnboundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price", Schema.FieldType.DATETIME, "order_time"}).timestampColumnIndex(3).addRows(Duration.ZERO, new Object[]{1, 1, 1, FIRST_DATE, 1, 2, 6, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 2, 7, SECOND_DATE, 2, 3, 8, SECOND_DATE, 1, 3, 3, FIRST_DATE}).addRows(WINDOW_SIZE.plus((ReadableDuration)WINDOW_SIZE).plus((ReadableDuration)Duration.standardMinutes((long)1L)), new Object[]{2, 3, 3, SECOND_DATE}).setStatistics(BeamTableStatistics.createUnboundedTableStatistics((Double)2.0)));
    }

    private NodeStats getEstimateOf(String sql) {
        BeamRelNode root = env.parseQuery(sql);
        while (!(root instanceof BeamAggregationRel)) {
            root = root.getInput(0);
        }
        return BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
    }

    @Test
    public void testNodeStats() {
        String sql = "SELECT order_id FROM ORDER_DETAILS_BOUNDED  GROUP BY order_id ";
        NodeStats estimate = this.getEstimateOf(sql);
        Assert.assertEquals((double)2.5, (double)estimate.getRowCount(), (double)0.001);
        Assert.assertEquals((double)2.5, (double)estimate.getWindow(), (double)0.001);
        Assert.assertEquals((double)0.0, (double)estimate.getRate(), (double)0.001);
    }

    @Test
    public void testNodeStatsEffectOfGroupSet() {
        String sql1 = "SELECT order_id FROM ORDER_DETAILS_BOUNDED  GROUP BY order_id ";
        String sql2 = "SELECT order_id, site_id FROM ORDER_DETAILS_BOUNDED  GROUP BY order_id, site_id ";
        NodeStats estimate1 = this.getEstimateOf(sql1);
        NodeStats estimate2 = this.getEstimateOf(sql2);
        Assert.assertTrue((estimate1.getRowCount() < estimate2.getRowCount() ? 1 : 0) != 0);
        Assert.assertTrue((estimate1.getWindow() < estimate2.getWindow() ? 1 : 0) != 0);
    }

    @Test
    public void testNodeStatsUnboundedWindow() {
        String sql = "select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS_UNBOUNDED  GROUP BY order_id, TUMBLE(order_time, INTERVAL '1' HOUR)";
        NodeStats estimate1 = this.getEstimateOf(sql);
        Assert.assertEquals((double)1.0, (double)estimate1.getRate(), (double)0.01);
        Assert.assertEquals((double)5.0, (double)estimate1.getWindow(), (double)0.01);
    }

    @Test
    public void testNodeStatsSlidingWindow() {
        String sql = "select order_id, sum(site_id) as sum_site_id FROM ORDER_DETAILS_UNBOUNDED  GROUP BY order_id, HOP(order_time, INTERVAL '1' SECOND,INTERVAL '3' SECOND)";
        NodeStats estimate1 = this.getEstimateOf(sql);
        Assert.assertEquals((double)3.0, (double)estimate1.getRate(), (double)0.01);
    }
}

