/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStatsMetadata;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.SingleRel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NodeStatsTest
extends BaseRelTest {
    public static final TestBoundedTable ORDER_DETAILS1 = TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price"}).addRows(new Object[]{1, 2, 3, 2, 3, 3, 3, 4, 5});
    public static final TestBoundedTable ORDER_DETAILS2 = TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "order_id", Schema.FieldType.INT32, "site_id", Schema.FieldType.INT32, "price"}).addRows(new Object[]{1, 2, 3, 2, 3, 3, 3, 4, 5});

    @BeforeClass
    public static void prepare() {
        NodeStatsTest.registerTable("ORDER_DETAILS1", (BeamSqlTable)ORDER_DETAILS1);
        NodeStatsTest.registerTable("ORDER_DETAILS2", (BeamSqlTable)ORDER_DETAILS2);
    }

    @Test
    public void testUnknownRel() {
        String sql = " select * from ORDER_DETAILS1 ";
        BeamRelNode root = env.parseQuery(sql);
        UnknownRel unknown = new UnknownRel(root.getCluster(), null, null);
        NodeStats nodeStats = ((NodeStatsMetadata)unknown.metadata(NodeStatsMetadata.class, unknown.getCluster().getMetadataQuery())).getNodeStats();
        Assert.assertTrue((boolean)nodeStats.isUnknown());
    }

    @Test
    public void testKnownRel() {
        String sql = " select * from ORDER_DETAILS1 ";
        BeamRelNode root = env.parseQuery(sql);
        NodeStats nodeStats = ((NodeStatsMetadata)root.metadata(NodeStatsMetadata.class, root.getCluster().getMetadataQuery())).getNodeStats();
        Assert.assertFalse((boolean)nodeStats.isUnknown());
    }

    @Test
    public void testSubsetHavingBest() {
        String sql = " select * from ORDER_DETAILS1 ";
        BeamRelNode root = env.parseQuery(sql);
        root = root.getCluster().getPlanner().getRoot();
        Assert.assertTrue((boolean)(root instanceof RelSubset));
        NodeStats estimates = BeamSqlRelUtils.getNodeStats((RelNode)root, (BeamRelMetadataQuery)((BeamRelMetadataQuery)root.getCluster().getMetadataQuery()));
        Assert.assertFalse((boolean)estimates.isUnknown());
    }

    static class UnknownRel
    extends SingleRel {
        protected UnknownRel(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
            super(cluster, traits, input);
        }
    }
}

