/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BaseRelTest;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestBoundedTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CalciteQueryPlannerTest
extends BaseRelTest {
    @Before
    public void prepare() {
        CalciteQueryPlannerTest.registerTable("medium_table", (BeamSqlTable)TestBoundedTable.of((Object[])new Object[]{Schema.FieldType.INT32, "unbounded_key", Schema.FieldType.INT32, "large_key", Schema.FieldType.INT32, "id"}).addRows(new Object[]{1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 4, 1, 1, 5}));
    }

    @Test
    public void testclusterCostHandlerUsesBeamCost() {
        String sql = "select * from medium_table";
        BeamRelNode root = env.parseQuery(sql);
        Assert.assertTrue((boolean)(root.getCluster().getPlanner().getCost((RelNode)root, root.getCluster().getMetadataQuery()) instanceof BeamCostModel));
    }

    @Test
    public void testNonCumulativeCostMetadataHandler() {
        String sql = "select * from medium_table";
        BeamRelNode root = env.parseQuery(sql);
        Assert.assertTrue((boolean)(root.getCluster().getMetadataQuery().getNonCumulativeCost((RelNode)root) instanceof BeamCostModel));
        Assert.assertFalse((boolean)root.getCluster().getMetadataQuery().getNonCumulativeCost((RelNode)root).isInfinite());
    }

    @Test
    public void testCumulativeCostMetaDataHandler() {
        String sql = "select * from medium_table";
        BeamRelNode root = env.parseQuery(sql);
        Assert.assertTrue((boolean)(root.getCluster().getMetadataQuery().getCumulativeCost((RelNode)root) instanceof BeamCostModel));
        Assert.assertFalse((boolean)root.getCluster().getMetadataQuery().getCumulativeCost((RelNode)root).isInfinite());
    }
}

