/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCost;
import org.junit.Assert;
import org.junit.Test;

public class BeamCostModelTest {
    @Test
    public void testDefaultConstructorIsInfinite() {
        BeamCostModel cost = BeamCostModel.FACTORY.makeCost(1.0, 1.0, 1.0);
        Assert.assertTrue((boolean)cost.isInfinite());
    }

    @Test
    public void testOneInfiniteValue() {
        BeamCostModel cost = BeamCostModel.FACTORY.makeCost(Double.POSITIVE_INFINITY, 1.0);
        Assert.assertTrue((boolean)cost.isInfinite());
    }

    @Test
    public void testComparisonOfBoundedCost() {
        BeamCostModel cost1 = BeamCostModel.FACTORY.makeCost(10.0, 0.0);
        BeamCostModel cost2 = BeamCostModel.FACTORY.makeCost(1.0, 0.0);
        BeamCostModel cost3 = BeamCostModel.FACTORY.makeCost(10.0, 0.0);
        Assert.assertTrue((boolean)cost2.isLt((RelOptCost)cost1));
        Assert.assertFalse((boolean)cost1.isLt((RelOptCost)cost2));
        Assert.assertFalse((boolean)cost1.isLt((RelOptCost)cost3));
        Assert.assertFalse((boolean)cost3.isLt((RelOptCost)cost1));
        Assert.assertTrue((boolean)cost3.isLe((RelOptCost)cost1));
    }

    @Test
    public void testComparisonOfUnboundedCost() {
        BeamCostModel cost1 = BeamCostModel.FACTORY.makeCost(0.0, 10.0);
        BeamCostModel cost2 = BeamCostModel.FACTORY.makeCost(0.0, 1.0);
        BeamCostModel cost3 = BeamCostModel.FACTORY.makeCost(0.0, 10.0);
        Assert.assertTrue((boolean)cost2.isLt((RelOptCost)cost1));
        Assert.assertFalse((boolean)cost1.isLt((RelOptCost)cost2));
        Assert.assertTrue((boolean)cost1.equals((RelOptCost)cost3));
        Assert.assertFalse((boolean)cost1.isLt((RelOptCost)cost3));
        Assert.assertFalse((boolean)cost3.isLt((RelOptCost)cost1));
        Assert.assertTrue((boolean)cost3.isLe((RelOptCost)cost1));
    }

    @Test
    public void testEffectOfRateVsRowCount() {
        BeamCostModel boundedCost = BeamCostModel.FACTORY.makeCost(10.0, 0.0);
        BeamCostModel unboundedCost = BeamCostModel.FACTORY.makeCost(0.0, 10.0);
        Assert.assertTrue((boolean)boundedCost.isLt((RelOptCost)unboundedCost));
        Assert.assertTrue((boolean)boundedCost.isLe((RelOptCost)unboundedCost));
        Assert.assertFalse((boolean)unboundedCost.isLe((RelOptCost)boundedCost));
    }

    @Test
    public void testComparisonInfiniteVsInfinite() {
        BeamCostModel inf1 = BeamCostModel.FACTORY.makeCost(Double.POSITIVE_INFINITY, 0.0);
        BeamCostModel inf2 = BeamCostModel.FACTORY.makeInfiniteCost();
        Assert.assertTrue((boolean)inf1.isLe((RelOptCost)inf2));
        Assert.assertTrue((boolean)inf2.isLe((RelOptCost)inf1));
        Assert.assertFalse((boolean)inf1.isLt((RelOptCost)inf2));
        Assert.assertFalse((boolean)inf2.isLt((RelOptCost)inf1));
    }

    @Test
    public void testComparisonInfiniteVsHuge() {
        BeamCostModel inf = BeamCostModel.FACTORY.makeCost(Double.POSITIVE_INFINITY, 0.0);
        BeamCostModel huge = BeamCostModel.FACTORY.makeHugeCost();
        Assert.assertTrue((boolean)huge.isLe((RelOptCost)inf));
        Assert.assertTrue((boolean)huge.isLt((RelOptCost)inf));
        Assert.assertFalse((boolean)inf.isLt((RelOptCost)huge));
        Assert.assertFalse((boolean)inf.isLt((RelOptCost)huge));
    }

    @Test
    public void testHugePlusHugeIsInfinite() {
        BeamCostModel cost = BeamCostModel.FACTORY.makeHugeCost().plus((RelOptCost)BeamCostModel.FACTORY.makeHugeCost());
        Assert.assertTrue((boolean)cost.isInfinite());
    }
}

