/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import org.apache.beam.sdk.extensions.sql.BeamSqlDslBase;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlCreateFunctionTest
extends BeamSqlDslBase {
    private final String jarPathProperty = "beam.sql.udf.test.jar_path";
    private final @Nullable String jarPath = System.getProperty("beam.sql.udf.test.jar_path");

    @Before
    public void setUp() {
        if (this.jarPath == null) {
            Assert.fail((String)String.format("System property %s must be set to run %s.", "beam.sql.udf.test.jar_path", SqlCreateFunctionTest.class.getSimpleName()));
        }
    }

    @Test
    public void createScalarFunction() throws Exception {
        String ddl = String.format("CREATE FUNCTION increment USING JAR '%s'", this.jarPath);
        String query = "SELECT increment(0)";
        PCollection stream = (PCollection)this.pipeline.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        Schema schema = Schema.builder().addInt64Field("field1").build();
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValues(new Object[]{1L}).build()});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void createAggregateFunction() throws Exception {
        String ddl = String.format("CREATE AGGREGATE FUNCTION my_sum USING JAR '%s'", this.jarPath);
        String query = "SELECT my_sum(f_long) FROM PCOLLECTION";
        PCollection stream = (PCollection)this.boundedInput1.apply((PTransform)SqlTransform.query((String)query).withDdlString(ddl));
        Schema schema = Schema.builder().addInt64Field("field1").build();
        PAssert.that((PCollection)stream).containsInAnyOrder((Object[])new Row[]{Row.withSchema((Schema)schema).addValues(new Object[]{10000L}).build()});
        this.pipeline.run().waitUntilFinish();
    }
}

