/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlCreateFunction;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableProvider;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.junit.Assert;
import org.junit.Test;

public class BeamDDLTest {
    @Test
    public void testParseCreateExternalTable_full() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        JSONObject properties = new JSONObject();
        JSONArray hello = new JSONArray();
        hello.add((Object)"james");
        hello.add((Object)"bond");
        properties.put("hello", (Object)hello);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", "person table", properties), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_WithComplexFields() {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE PersonDetails ( personInfo MAP<VARCHAR, ROW<field_1 INTEGER,field_2 VARCHAR>> ,  additionalInfo ROW<field_0 TIMESTAMP,field_1 INTEGER,field_2 TINYINT> ) TYPE 'text' LOCATION '/home/admin/person'");
        Assert.assertNotNull(tableProvider.getTables().get("PersonDetails"));
    }

    @Test(expected=ParseException.class)
    public void testParseCreateExternalTable_withoutType() throws Exception {
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)new TestTableProvider());
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
    }

    @Test(expected=ParseException.class)
    public void testParseCreateTable() throws Exception {
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)new TestTableProvider());
        env.executeDdl("CREATE TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
    }

    @Test
    public void testParseCreateExternalTable_withoutTableComment() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        JSONObject properties = new JSONObject();
        JSONArray hello = new JSONArray();
        hello.add((Object)"james");
        hello.add((Object)"bond");
        properties.put("hello", (Object)hello);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nLOCATION '/home/admin/person'\nTBLPROPERTIES '{\"hello\": [\"james\", \"bond\"]}'");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", null, properties), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_withoutTblProperties() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \nLOCATION '/home/admin/person'\n");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", "person table", new JSONObject()), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_withoutLocation() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \n");
        Assert.assertEquals((Object)BeamDDLTest.mockTable("person", "text", "person table", new JSONObject(), null), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_minimal() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        env.executeDdl("CREATE EXTERNAL TABLE person (id INT) TYPE text");
        Assert.assertEquals((Object)Table.builder().name("person").type("text").schema((Schema)Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withNullable(true)).collect(Schema.toSchema())).properties(new JSONObject()).build(), tableProvider.getTables().get("person"));
    }

    @Test
    public void testParseCreateExternalTable_withDatabase() throws Exception {
        TestTableProvider rootProvider = new TestTableProvider();
        TestTableProvider testProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.builder((TableProvider)rootProvider).addSchema("test", (TableProvider)testProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
        Assert.assertNull(testProvider.getTables().get("person"));
        env.executeDdl("CREATE EXTERNAL TABLE test.person (id INT) TYPE text");
        Assert.assertNotNull(testProvider.getTables().get("person"));
    }

    @Test
    public void testParseDropTable() throws Exception {
        TestTableProvider tableProvider = new TestTableProvider();
        BeamSqlEnv env = BeamSqlEnv.withTableProvider((TableProvider)tableProvider);
        Assert.assertNull(tableProvider.getTables().get("person"));
        env.executeDdl("CREATE EXTERNAL TABLE person (\nid int COMMENT 'id', \nname varchar COMMENT 'name') \nTYPE 'text' \nCOMMENT 'person table' \n");
        Assert.assertNotNull(tableProvider.getTables().get("person"));
        env.executeDdl("drop table person");
        Assert.assertNull(tableProvider.getTables().get("person"));
    }

    @Test
    public void unparseScalarFunction() {
        SqlIdentifier name = new SqlIdentifier("foo", SqlParserPos.ZERO);
        SqlCharStringLiteral jarPath = SqlLiteral.createCharString((String)"path/to/udf.jar", (SqlParserPos)SqlParserPos.ZERO);
        SqlCreateFunction createFunction = new SqlCreateFunction(SqlParserPos.ZERO, false, name, (SqlNode)jarPath, false);
        SqlPrettyWriter sqlWriter = new SqlPrettyWriter(BeamBigQuerySqlDialect.DEFAULT);
        createFunction.unparse((SqlWriter)sqlWriter, 0, 0);
        Assert.assertEquals((Object)"CREATE FUNCTION foo USING JAR 'path/to/udf.jar'", (Object)sqlWriter.toSqlString().getSql());
    }

    @Test
    public void unparseAggregateFunction() {
        SqlIdentifier name = new SqlIdentifier("foo", SqlParserPos.ZERO);
        SqlCharStringLiteral jarPath = SqlLiteral.createCharString((String)"path/to/udf.jar", (SqlParserPos)SqlParserPos.ZERO);
        SqlCreateFunction createFunction = new SqlCreateFunction(SqlParserPos.ZERO, false, name, (SqlNode)jarPath, true);
        SqlPrettyWriter sqlWriter = new SqlPrettyWriter(BeamBigQuerySqlDialect.DEFAULT);
        createFunction.unparse((SqlWriter)sqlWriter, 0, 0);
        Assert.assertEquals((Object)"CREATE AGGREGATE FUNCTION foo USING JAR 'path/to/udf.jar'", (Object)sqlWriter.toSqlString().getSql());
    }

    private static Table mockTable(String name, String type, String comment, JSONObject properties) {
        return BeamDDLTest.mockTable(name, type, comment, properties, "/home/admin/" + name);
    }

    private static Table mockTable(String name, String type, String comment, JSONObject properties, String location) {
        return Table.builder().name(name).type(type).comment(comment).location(location).schema((Schema)Stream.of(Schema.Field.of((String)"id", (Schema.FieldType)CalciteUtils.INTEGER).withNullable(true).withDescription("id"), Schema.Field.of((String)"name", (Schema.FieldType)CalciteUtils.VARCHAR).withNullable(true).withDescription("name")).collect(Schema.toSchema())).properties(properties).build();
    }
}

