/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFnReflector;
import org.apache.beam.sdk.extensions.sql.udf.ScalarFn;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ScalarFnReflectorTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testGetApplyMethod() throws InvocationTargetException, IllegalAccessException {
        IncrementFn incrementFn = new IncrementFn();
        Method method = ScalarFnReflector.getApplyMethod((ScalarFn)incrementFn);
        @Nullable Object result = method.invoke((Object)incrementFn, 24L);
        Assert.assertEquals((Object)25L, (Object)result);
    }

    @Test
    public void testGetApplyMethodOverride() throws InvocationTargetException, IllegalAccessException {
        IncrementFnChild incrementFn = new IncrementFnChild();
        Method method = ScalarFnReflector.getApplyMethod((ScalarFn)incrementFn);
        @Nullable Object result = method.invoke((Object)incrementFn, 24L);
        Assert.assertEquals((Object)26L, (Object)result);
    }

    @Test
    public void testGetApplyMethodStatic() throws InvocationTargetException, IllegalAccessException {
        Method method = ScalarFnReflector.getApplyMethod((ScalarFn)new IncrementFnWithStaticMethod());
        @Nullable Object result = method.invoke(null, 24L);
        Assert.assertEquals((Object)25L, (Object)result);
    }

    @Test
    public void testDifferentMethodNameThrowsIllegalArgumentException() {
        this.thrown.expect(Matchers.instanceOf(IllegalArgumentException.class));
        this.thrown.expectMessage("Found multiple methods annotated with @ApplyMethod.");
        ScalarFnReflector.getApplyMethod((ScalarFn)new IncrementFnDifferentMethodName());
    }

    @Test
    public void testDifferentMethodSignatureThrowsIllegalArgumentException() {
        this.thrown.expect(Matchers.instanceOf(IllegalArgumentException.class));
        this.thrown.expectMessage("Found multiple methods annotated with @ApplyMethod.");
        ScalarFnReflector.getApplyMethod((ScalarFn)new IncrementFnDifferentSignature());
    }

    @Test
    public void testMissingAnnotationThrowsIllegalArgumentException() {
        this.thrown.expect(Matchers.instanceOf(IllegalArgumentException.class));
        this.thrown.expectMessage("No method annotated with @ApplyMethod found in class");
        ScalarFnReflector.getApplyMethod((ScalarFn)new IncrementFnMissingAnnotation());
    }

    @Test
    public void testNonPublicMethodThrowsIllegalArgumentException() {
        this.thrown.expect(Matchers.instanceOf(IllegalArgumentException.class));
        this.thrown.expectMessage("not public");
        ScalarFnReflector.getApplyMethod((ScalarFn)new IncrementFnWithProtectedMethod());
    }

    static class IncrementFnWithProtectedMethod
    extends ScalarFn {
        IncrementFnWithProtectedMethod() {
        }

        @ScalarFn.ApplyMethod
        protected Long increment(Long i) {
            return i + 1L;
        }
    }

    static class IncrementFnMissingAnnotation
    extends ScalarFn {
        IncrementFnMissingAnnotation() {
        }

        public Long increment(Long i) {
            return i + 1L;
        }
    }

    static class IncrementFnDifferentSignature
    extends IncrementFn {
        IncrementFnDifferentSignature() {
        }

        @ScalarFn.ApplyMethod
        public Long increment(String s) {
            return 0L;
        }
    }

    static class IncrementFnDifferentMethodName
    extends IncrementFn {
        IncrementFnDifferentMethodName() {
        }

        @ScalarFn.ApplyMethod
        public Long differentMethod(Long i) {
            return i + 2L;
        }
    }

    static class IncrementFnWithStaticMethod
    extends ScalarFn {
        IncrementFnWithStaticMethod() {
        }

        @ScalarFn.ApplyMethod
        public static Long increment(Long i) {
            return i + 1L;
        }
    }

    static class IncrementFnChild
    extends IncrementFn {
        IncrementFnChild() {
        }

        @Override
        @ScalarFn.ApplyMethod
        public Long increment(Long i) {
            return i + 2L;
        }
    }

    static class IncrementFn
    extends ScalarFn {
        IncrementFn() {
        }

        @ScalarFn.ApplyMethod
        public Long increment(Long i) {
            return i + 1L;
        }
    }
}

