/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.List;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.extensions.sql.impl.LazyAggregateCombineFn;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.udf.AggregateFn;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

@RunWith(value=JUnit4.class)
public class LazyAggregateCombineFnTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void getAccumulatorCoderInfersCoderForWildcardTypeParameter() throws CannotProvideCoderException {
        LazyAggregateCombineFn combiner = new LazyAggregateCombineFn((AggregateFn)new Sum());
        Coder coder = combiner.getAccumulatorCoder(CoderRegistry.createDefault(), (Coder)VarLongCoder.of());
        MatcherAssert.assertThat((Object)coder, (Matcher)Matchers.instanceOf(VarLongCoder.class));
    }

    @Test
    public void mergeAccumulators() {
        LazyAggregateCombineFn combiner = new LazyAggregateCombineFn((AggregateFn)new Sum());
        long merged = (Long)combiner.mergeAccumulators((Iterable)ImmutableList.of((Object)1L, (Object)1L));
        Assert.assertEquals((long)2L, (long)merged);
    }

    @Test
    public void nonparameterizedGetUdafImpl_throwsIllegalStateException() {
        LazyAggregateCombineFn combiner = new LazyAggregateCombineFn((AggregateFn)new NonParameterizedAggregateFn());
        UdafImpl aggregateFunction = combiner.getUdafImpl();
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.exceptions.expect(IllegalStateException.class);
        List params = aggregateFunction.getParameters();
        ((FunctionParameter)params.get(0)).getType((RelDataTypeFactory)typeFactory);
    }

    public static class NonParameterizedAggregateFn
    implements AggregateFn {
        public @Nullable Object createAccumulator() {
            return null;
        }

        public @Nullable Object addInput(Object mutableAccumulator, Object input) {
            return null;
        }

        public @Nullable Object mergeAccumulators(Object mutableAccumulator, Iterable immutableAccumulators) {
            return null;
        }

        public @Nullable Object extractOutput(Object mutableAccumulator) {
            return null;
        }
    }

    public static class SumChild
    extends Sum {
    }

    public static class Sum
    implements AggregateFn<Long, Long, Long> {
        public Long createAccumulator() {
            return 0L;
        }

        public Long addInput(Long mutableAccumulator, Long input) {
            return mutableAccumulator + input;
        }

        public Long mergeAccumulators(Long mutableAccumulator, Iterable<Long> immutableAccumulators) {
            for (Long x : immutableAccumulators) {
                mutableAccumulator = mutableAccumulator + x;
            }
            return mutableAccumulator;
        }

        public Long extractOutput(Long mutableAccumulator) {
            return mutableAccumulator;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class UdafImplTest {
        @Parameterized.Parameter
        public AggregateFn aggregateFn;

        @Parameterized.Parameters(name="aggregateFn: {0}")
        public static Object[] data() {
            return new Object[]{new Sum(), new SumChild()};
        }

        @Test
        public void subclassGetUdafImpl() {
            LazyAggregateCombineFn combiner = new LazyAggregateCombineFn(this.aggregateFn);
            UdafImpl aggregateFunction = combiner.getUdafImpl();
            JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
            RelDataType expectedType = typeFactory.createJavaType(Long.class);
            List params = aggregateFunction.getParameters();
            MatcherAssert.assertThat((Object)params, (Matcher)Matchers.hasSize((int)1));
            RelDataType paramType = ((FunctionParameter)params.get(0)).getType((RelDataTypeFactory)typeFactory);
            Assert.assertEquals((Object)expectedType, (Object)paramType);
            RelDataType returnType = aggregateFunction.getReturnType((RelDataTypeFactory)typeFactory);
            Assert.assertEquals((Object)expectedType, (Object)returnType);
        }
    }
}

