/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.io.IOException;
import java.nio.file.ProviderNotFoundException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlCreateFunctionTest;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JavaUdfLoaderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final String jarPathProperty = "beam.sql.udf.test.jar_path";
    private final String emptyJarPathProperty = "beam.sql.udf.test.empty_jar_path";
    private final String jarPath = System.getProperty("beam.sql.udf.test.jar_path", "");
    private final String emptyJarPath = System.getProperty("beam.sql.udf.test.empty_jar_path", "");

    @Before
    public void setUp() {
        if (this.jarPath == null) {
            Assert.fail((String)String.format("System property %s must be set to run %s.", "beam.sql.udf.test.jar_path", SqlCreateFunctionTest.class.getSimpleName()));
        }
        if (this.emptyJarPath == null) {
            Assert.fail((String)String.format("System property %s must be set to run %s.", "beam.sql.udf.test.empty_jar_path", SqlCreateFunctionTest.class.getSimpleName()));
        }
    }

    @Test
    public void testClassLoaderHasNoUdfProviders() throws IOException {
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        Iterator udfProviders = udfLoader.getUdfProviders(ReflectHelpers.findClassLoader());
        Assert.assertFalse((boolean)udfProviders.hasNext());
    }

    @Test
    public void testLoadScalarFunction() {
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        udfLoader.loadScalarFunction(Collections.singletonList("helloWorld"), this.jarPath);
    }

    @Test
    public void testLoadAggregateFunction() {
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        udfLoader.loadAggregateFunction(Collections.singletonList("my_sum"), this.jarPath);
    }

    @Test
    public void testLoadUnregisteredScalarFunctionThrowsRuntimeException() {
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(String.format("No implementation of scalar function notRegistered found in %s.", this.jarPath));
        udfLoader.loadScalarFunction(Collections.singletonList("notRegistered"), this.jarPath);
    }

    @Test
    public void testLoadUnregisteredAggregateFunctionThrowsRuntimeException() {
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage(String.format("No implementation of aggregate function notRegistered found in %s.", this.jarPath));
        udfLoader.loadAggregateFunction(Collections.singletonList("notRegistered"), this.jarPath);
    }

    @Test
    public void testJarMissingUdfProviderThrowsProviderNotFoundException() {
        JavaUdfLoader udfLoader = new JavaUdfLoader();
        this.thrown.expect(ProviderNotFoundException.class);
        this.thrown.expectMessage(String.format("No UdfProvider implementation found in %s.", this.emptyJarPath));
        udfLoader.loadScalarFunction(Collections.singletonList("helloWorld"), this.jarPath);
        udfLoader.loadScalarFunction(Collections.singletonList("helloWorld"), this.emptyJarPath);
    }
}

