/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.TypedCombineFnDelegate;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TypedCombineFnDelegateTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testParameterExtractionFromCombineFn_CombineFnDelegate() {
        Combine.BinaryCombineFn max = Max.of((Comparator & Serializable)(a, b) -> Integer.compare(a.length(), b.length()));
        UdafImpl udaf = new UdafImpl((Combine.CombineFn)new TypedCombineFnDelegate<String, Combine.Holder<String>, String>((Combine.CombineFn)max){});
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        List parameters = udaf.getParameters();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((FunctionParameter)parameters.get(0)).getType((RelDataTypeFactory)typeFactory).getSqlTypeName());
    }

    @Test
    public void testParameterExtractionFromCombineFn_CombineFnDelegate_WithGenericArray() {
        Combine.BinaryCombineFn max = Max.of((Comparator & Serializable)(a, b) -> Integer.compare(((String)a[0].get(0)).length(), ((String)b[0].get(0)).length()));
        UdafImpl udaf = new UdafImpl((Combine.CombineFn)new TypedCombineFnDelegate<List<String>[], Combine.Holder<List<String>[]>, List<String>[]>((Combine.CombineFn)max){});
        this.exceptions.expect(IllegalArgumentException.class);
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        ((FunctionParameter)udaf.getParameters().get(0)).getType((RelDataTypeFactory)typeFactory);
    }

    @Test
    public void testParameterExtractionFromCombineFn_CombineFnDelegate_WithListInsteadOfArray() {
        Combine.BinaryCombineFn max = Max.of((Comparator & Serializable)(a, b) -> Integer.compare(((String)((List)a.get(0)).get(0)).length(), ((String)((List)b.get(0)).get(0)).length()));
        UdafImpl udaf = new UdafImpl((Combine.CombineFn)new TypedCombineFnDelegate<List<List<String>>, Combine.Holder<List<List<String>>>, List<List<String>>>((Combine.CombineFn)max){});
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        List parameters = udaf.getParameters();
        Assert.assertEquals((long)1L, (long)parameters.size());
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)((FunctionParameter)parameters.get(0)).getType((RelDataTypeFactory)typeFactory).getSqlTypeName());
    }
}

