/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.meta.provider.test.TestTableUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class TestUtils {
    public static List<String> beamSqlRows2Strings(List<Row> rows) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Row row : rows) {
            strs.add(row.toString(false));
        }
        return strs;
    }

    public static RowsBuilder rowsBuilderOf(Schema type) {
        return RowsBuilder.of(type);
    }

    public static PCollectionBuilder pCollectionBuilder() {
        return new PCollectionBuilder();
    }

    public static <T> PCollectionTuple tuple(String tag, PCollection<T> pCollection) {
        return PCollectionTuple.of((TupleTag)new TupleTag(tag), pCollection);
    }

    public static <T, V> PCollectionTuple tuple(String tag1, PCollection<T> pCollection1, String tag2, PCollection<V> pCollection2) {
        return TestUtils.tuple(tag1, pCollection1).and(new TupleTag(tag2), pCollection2);
    }

    public static <T, V, W> PCollectionTuple tuple(String tag1, PCollection<T> pCollection1, String tag2, PCollection<V> pCollection2, String tag3, PCollection<W> pCollection3) {
        return TestUtils.tuple(tag1, pCollection1, tag2, pCollection2).and(new TupleTag(tag3), pCollection3);
    }

    static class PCollectionBuilder {
        private Schema type;
        private List<Row> rows;
        private String timestampField;
        private Pipeline pipeline;

        PCollectionBuilder() {
        }

        public PCollectionBuilder withSchema(Schema type) {
            this.type = type;
            return this;
        }

        public PCollectionBuilder withRows(List<Row> rows) {
            this.rows = rows;
            return this;
        }

        public PCollectionBuilder withTimestampField(String timestampField) {
            this.timestampField = timestampField;
            return this;
        }

        public PCollectionBuilder inPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public PCollection<Row> buildUnbounded() {
            Preconditions.checkArgument((this.pipeline != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.rows.size() > 0 ? 1 : 0) != 0);
            if (this.type == null) {
                this.type = this.rows.get(0).getSchema();
            }
            TestStream.Builder values = TestStream.create((Schema)this.type);
            for (Row row : this.rows) {
                if (this.timestampField != null) {
                    values = values.advanceWatermarkTo(new Instant((Object)row.getDateTime(this.timestampField)));
                }
                values = values.addElements((Object)row, (Object[])new Row[0]);
            }
            return (PCollection)PBegin.in((Pipeline)this.pipeline).apply("unboundedPCollection", (PTransform)values.advanceWatermarkToInfinity());
        }
    }

    public static class RowsBuilder {
        private Schema type;
        private List<Row> rows = new ArrayList<Row>();

        public static RowsBuilder of(Object ... args) {
            Schema beamSQLSchema = TestTableUtils.buildBeamSqlSchema((Object[])args);
            RowsBuilder builder = new RowsBuilder();
            builder.type = beamSQLSchema;
            return builder;
        }

        public static RowsBuilder ofNullable(Object ... args) {
            Schema beamSQLSchema = TestTableUtils.buildBeamSqlNullableSchema((Object[])args);
            RowsBuilder builder = new RowsBuilder();
            builder.type = beamSQLSchema;
            return builder;
        }

        public static RowsBuilder of(Schema schema) {
            RowsBuilder builder = new RowsBuilder();
            builder.type = schema;
            return builder;
        }

        public RowsBuilder addRows(Object ... args) {
            this.rows.addAll(TestTableUtils.buildRows((Schema)this.type, Arrays.asList(args)));
            return this;
        }

        public RowsBuilder addRows(List args) {
            this.rows.addAll(TestTableUtils.buildRows((Schema)this.type, (List)args));
            return this;
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public List<String> getStringRows() {
            return TestUtils.beamSqlRows2Strings(this.rows);
        }

        public PCollectionBuilder getPCollectionBuilder() {
            return TestUtils.pCollectionBuilder().withSchema(this.type).withRows(this.rows);
        }
    }

    public static class BeamSqlRow2StringDoFn
    extends DoFn<Row, String> {
        @DoFn.ProcessElement
        public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<String> o) {
            o.output((Object)row.toString(false));
        }
    }
}

